<?php

/**
 * FORQY Widgets
 *
 * @version 1.0.4
 * @author  FORQY
 * @url     https://forqy.website/
 * @license GPL-3.0-or-later
 */

if ( ! function_exists( 'forqy_widgets_scripts' ) ) {

	/**
	 * Scripts
	 */
	function forqy_widgets_scripts() {

		/**
		 * Widget
		 */

		// Register
		wp_register_script( 'forqy-widget', plugins_url( 'assets/js/widget.js', __FILE__ ), array(
			'jquery',
		) );

		// Localize
		wp_localize_script( 'forqy-widget', 'translation', array(
			'select_image'       => esc_html__( 'Select image', 'forqy' ),
			'use_selected_image' => esc_html__( 'Use selected image', 'forqy' ),
		) );

		// Enqueue
		wp_enqueue_script( 'forqy-widget' );

	}

	add_action( 'admin_enqueue_scripts', 'forqy_widgets_scripts' );

}
