<?php

/**
 * Sub-pages Widget
 *
 * @since 1.0.0
 */
class FORQY_Widget_Subpages extends WP_Widget {

	/**
	 * Register
	 */
	public function __construct() {

		parent::__construct( 'forqy_subpages', defined( 'FORQY_THEME_NAME' ) ? FORQY_THEME_NAME . ' &mdash; ' . esc_html_x( 'Sub-pages', 'widget', 'forqy' ) : esc_html_x( 'Sub-pages', 'widget', 'forqy' ), array(
			'classname'             => 'widget_pages widget_subpages',
			'description'           => '',
			'customizer_support'    => true,
			'show_instance_in_rest' => true,
		) );

	}

	/**
	 * Display
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {

		extract( $args );

		$widget_title = apply_filters( 'widget_title', $instance['title'] );

		if ( ! is_page() ) {
			return;
		}

		$post = get_queried_object();

		if ( 0 >= $post->post_parent ) {
			$children = wp_list_pages( array(
				'child_of' => get_queried_object_id(),
				'echo'     => false,
				'title_li' => false,
			) );
		} else if ( $post->ancestors ) {
			$ancestors = $post->ancestors;
			$ancestors = end( $ancestors );
			$children  = wp_list_pages( array(
				'child_of' => $ancestors,
				'title_li' => false,
				'echo'     => false,
			) );
		}

		if ( empty( $children ) ) {
			return;
		}

		echo $args['before_widget'];

		if ( $widget_title ) {
			echo $args['before_title'] . esc_html( $widget_title ) . $args['after_title'];
		} ?>

        <ul><?php echo $children; ?></ul>

		<?php
		echo $args['after_widget'];

	}

	/**
	 * Update
	 *
	 * @param array $new_instance
	 * @param array $old_instance
	 *
	 * @return array
	 */
	public function update( $new_instance, $old_instance ): array {

		$instance = array();

		$instance['title'] = isset( $new_instance['title'] ) ? strip_tags( $new_instance['title'] ) : '';

		return $instance;
	}

	/**
	 * Form
	 *
	 * @param array $instance
	 *
	 * @return void
	 */
	public function form( $instance ) {

		$instance = wp_parse_args( (array) $instance, array(
			'title' => esc_html__( 'Sub-pages', 'forqy' )
		) );

		$widget_title = $instance['title'] ?? '';
		?>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
				<?php echo esc_html_x( 'Title', 'widget', 'forqy' ); ?>
            </label>

            <input type="text" class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>"
                   value="<?php echo esc_attr( $widget_title ); ?>">
        </p>

	<?php }

}
