<?php

/**
 * Socials Widget
 *
 * @since 1.0.0
 */
class FORQY_Widget_Socials extends WP_Widget {

	/**
	 * Register
	 */
	public function __construct() {

		parent::__construct( 'forqy_socials', defined( 'FORQY_THEME_NAME' ) ? FORQY_THEME_NAME . ' &mdash; ' . esc_html_x( 'Socials', 'widget', 'forqy' ) : esc_html_x( 'Socials', 'widget', 'forqy' ), array(
			'classname'             => 'widget_socials',
			'description'           => '',
			'customizer_support'    => true,
			'show_instance_in_rest' => true,
		) );

	}

	/**
	 * Display
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {

		extract( $args );

		// Vars
		$widget_title   = apply_filters( 'widget_title', $instance['title'] );
		$widget_content = apply_filters( 'widget_content', $instance['content'] );

		echo $args['before_widget'];

		if ( $widget_title ) {
			echo $args['before_title'] . esc_html( $widget_title ) . $args['after_title'];
		}

		if ( $widget_content ) { ?>
            <div class="fy-widget-content fy-content">
				<?php echo wp_kses_post( wpautop( do_shortcode( $widget_content ) ) ); ?>
            </div>
		<?php }

		get_template_part( 'templates/social/socials' );

		echo $args['after_widget'];

	}

	/**
	 * Update
	 *
	 * @param array $new_instance
	 * @param array $old_instance
	 *
	 * @return array
	 */
	public function update( $new_instance, $old_instance ): array {

		$instance = array();

		$instance['title']   = isset( $new_instance['title'] ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['content'] = $new_instance['content'] ?? '';

		return $instance;
	}

	/**
	 * Form
	 *
	 * @param array $instance
	 *
	 * @return void
	 */
	public function form( $instance ) {

		$instance = wp_parse_args( (array) $instance, array(
			'title' => esc_html__( 'Follow Us', 'forqy' ),
		) );

		$widget_title   = $instance['title'] ?? '';
		$widget_content = $instance['content'] ?? '';
		?>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
				<?php echo esc_html_x( 'Title', 'widget', 'forqy' ); ?>
            </label>

            <input type="text" class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>"
                   value="<?php echo esc_attr( $widget_title ); ?>">
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>">
				<?php echo esc_html_x( 'Content', 'widget', 'forqy' ); ?>
            </label>

            <textarea class="widefat" rows="12" cols="20"
                      id="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>"
                      name="<?php echo esc_attr( $this->get_field_name( 'content' ) ); ?>"><?php echo esc_textarea( $widget_content ); ?></textarea>
        </p>

	<?php }

}
