<?php

/**
 * Opening Hours Widget
 *
 * @since 1.0.0
 */
class FORQY_Widget_Opening_Hours extends WP_Widget {

	/**
	 * Register
	 */
	public function __construct() {

		parent::__construct( 'forqy_opening_hours', defined( 'FORQY_THEME_NAME' ) ? FORQY_THEME_NAME . ' &mdash; ' . esc_html_x( 'Opening Hours', 'widget', 'forqy' ) : esc_html_x( 'Opening Hours', 'widget', 'forqy' ), array(
			'classname'             => 'widget_opening_hours',
			'description'           => '',
			'customizer_support'    => true,
			'show_instance_in_rest' => true,
		) );

	}

	/**
	 * Display
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {

		extract( $args );

		// Vars
		$widget_title   = apply_filters( 'widget_title', $instance['title'] );
		$widget_content = apply_filters( 'widget_content', $instance['content'] );

		echo $args['before_widget'];

		if ( $widget_title ) {
			echo $args['before_title'] . esc_attr( $widget_title ) . $args['after_title'];
		}

		if ( $widget_content ) { ?>
            <div class="fy-widget-content fy-content">
				<?php echo wp_kses_post( wpautop( do_shortcode( $widget_content ) ) ); ?>
            </div>
		<?php }

		if ( ! empty( $instance['monday'] ) ) { ?>
            <div class="fy-day">
                <strong class="fy-float-left"><?php esc_html_e( 'Monday', 'forqy' ); ?></strong> <span
                        class="fy-float-right"><?php echo esc_html( $instance['monday'] ); ?></span></div>
		<?php }

		if ( ! empty( $instance['tuesday'] ) ) { ?>
            <div class="fy-day">
                <strong class="fy-float-left"><?php esc_html_e( 'Tuesday', 'forqy' ); ?></strong> <span
                        class="fy-float-right"><?php echo esc_html( $instance['tuesday'] ); ?></span></div>
		<?php }

		if ( ! empty( $instance['wednesday'] ) ) { ?>
            <div class="fy-day">
                <strong class="fy-float-left"><?php esc_html_e( 'Wednesday', 'forqy' ); ?></strong> <span
                        class="fy-float-right"><?php echo esc_html( $instance['wednesday'] ); ?></span></div>
		<?php }

		if ( ! empty( $instance['thursday'] ) ) { ?>
            <div class="fy-day">
                <strong class="fy-float-left"><?php esc_html_e( 'Thursday', 'forqy' ); ?></strong> <span
                        class="fy-float-right"><?php echo esc_html( $instance['thursday'] ); ?></span></div>
		<?php }

		if ( ! empty( $instance['friday'] ) ) { ?>
            <div class="fy-day">
                <strong class="fy-float-left"><?php esc_html_e( 'Friday', 'forqy' ); ?></strong> <span
                        class="fy-float-right"><?php echo esc_html( $instance['friday'] ); ?></span></div>
		<?php }

		if ( ! empty( $instance['saturday'] ) ) { ?>
            <div class="fy-day">
                <strong class="fy-float-left"><?php esc_html_e( 'Saturday', 'forqy' ); ?></strong> <span
                        class="fy-float-right"><?php echo esc_html( $instance['saturday'] ); ?></span></div>
		<?php }

		if ( ! empty( $instance['sunday'] ) ) { ?>
            <div class="fy-day">
                <strong class="fy-float-left"><?php esc_html_e( 'Sunday', 'forqy' ); ?></strong> <span
                        class="fy-float-right"><?php echo esc_html( $instance['sunday'] ); ?></span></div>
		<?php }

		echo $args['after_widget'];

	}

	/**
	 * Update
	 *
	 * @param array $new_instance
	 * @param array $old_instance
	 *
	 * @return array
	 */
	public function update( $new_instance, $old_instance ): array {

		$instance = array();

		$instance['title']   = isset( $new_instance['title'] ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['content'] = $new_instance['content'] ?? '';

		$instance['monday']    = isset( $new_instance['monday'] ) ? strip_tags( $new_instance['monday'] ) : '';
		$instance['tuesday']   = isset( $new_instance['tuesday'] ) ? strip_tags( $new_instance['tuesday'] ) : '';
		$instance['wednesday'] = isset( $new_instance['wednesday'] ) ? strip_tags( $new_instance['wednesday'] ) : '';
		$instance['thursday']  = isset( $new_instance['thursday'] ) ? strip_tags( $new_instance['thursday'] ) : '';
		$instance['friday']    = isset( $new_instance['friday'] ) ? strip_tags( $new_instance['friday'] ) : '';
		$instance['saturday']  = isset( $new_instance['saturday'] ) ? strip_tags( $new_instance['saturday'] ) : '';
		$instance['sunday']    = isset( $new_instance['sunday'] ) ? strip_tags( $new_instance['sunday'] ) : '';

		return $instance;
	}

	/**
	 * Form
	 *
	 * @param array $instance
	 *
	 * @return void
	 */
	public function form( $instance ) {

		$defaults = array(
			'title'     => esc_html__( 'Opening Hours', 'forqy' ),
			'monday'    => esc_html__( 'Closed', 'forqy' ),
			'tuesday'   => esc_html__( '10:00 AM - 11:00 PM', 'forqy' ),
			'wednesday' => esc_html__( '10:00 AM - 11:00 PM', 'forqy' ),
			'thursday'  => esc_html__( '10:00 AM - 11:00 PM', 'forqy' ),
			'friday'    => esc_html__( '10:00 AM - 11:00 PM', 'forqy' ),
			'saturday'  => esc_html__( '10:00 AM - 11:00 PM', 'forqy' ),
			'sunday'    => esc_html__( '10:00 AM - 11:00 PM', 'forqy' ),
		);

		$instance = wp_parse_args( (array) $instance, $defaults );

		$widget_title   = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$widget_content = isset( $instance['content'] ) ? esc_attr( $instance['content'] ) : '';

		$monday    = $instance['monday'] ?? '';
		$tuesday   = $instance['tuesday'] ?? '';
		$wednesday = $instance['wednesday'] ?? '';
		$thursday  = $instance['thursday'] ?? '';
		$friday    = $instance['friday'] ?? '';
		$saturday  = $instance['saturday'] ?? '';
		$sunday    = $instance['sunday'] ?? '';
		?>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
				<?php echo esc_html_x( 'Title', 'widget', 'forqy' ); ?></label>

            <input type="text" class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>"
                   value="<?php echo esc_attr( $widget_title ); ?>">
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>">
				<?php echo esc_html_x( 'Content', 'widget', 'forqy' ); ?></label>

            <textarea class="widefat" rows="12" cols="20"
                      id="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>"
                      name="<?php echo esc_attr( $this->get_field_name( 'content' ) ); ?>"><?php echo esc_textarea( $widget_content ); ?></textarea>
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'monday' ) ); ?>">
				<?php esc_html_e( 'Monday', 'forqy' ); ?>:</label>

            <input type="text" class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'monday' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'monday' ) ); ?>"
                   value="<?php echo esc_attr( $monday ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'tuesday' ) ); ?>">
				<?php esc_html_e( 'Tuesday', 'forqy' ); ?>:</label>

            <input type="text" class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'tuesday' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'tuesday' ) ); ?>"
                   value="<?php echo esc_attr( $tuesday ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'wednesday' ) ); ?>">
				<?php esc_html_e( 'Wednesday', 'forqy' ); ?>:</label>

            <input type="text" class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'wednesday' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'wednesday' ) ); ?>"
                   value="<?php echo esc_attr( $wednesday ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'thursday' ) ); ?>">
				<?php esc_html_e( 'Thursday', 'forqy' ); ?>:</label>

            <input type="text" class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'thursday' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'thursday' ) ); ?>"
                   value="<?php echo esc_attr( $thursday ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'friday' ) ); ?>">
				<?php esc_html_e( 'Friday', 'forqy' ); ?>:</label>

            <input type="text" class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'friday' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'friday' ) ); ?>"
                   value="<?php echo esc_attr( $friday ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'saturday' ) ); ?>">
				<?php esc_html_e( 'Saturday', 'forqy' ); ?>:</label>

            <input type="text" class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'saturday' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'saturday' ) ); ?>"
                   value="<?php echo esc_attr( $saturday ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'sunday' ) ); ?>">
				<?php esc_html_e( 'Sunday', 'forqy' ); ?>:</label>

            <input type="text" class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'sunday' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'sunday' ) ); ?>"
                   value="<?php echo esc_attr( $sunday ); ?>">
        </p>

	<?php }

}
