<?php

/**
 * Image Widget
 *
 * @since 1.0.0
 */
class FORQY_Widget_Image extends WP_Widget {

	/**
	 * Register
	 */
	public function __construct() {

		parent::__construct( 'forqy_image', defined( 'FORQY_THEME_NAME' ) ? FORQY_THEME_NAME . ' &mdash; ' . esc_html_x( 'Image', 'widget', 'forqy' ) : esc_html_x( 'Image', 'widget', 'forqy' ), array(
			'classname'             => 'widget_image',
			'description'           => '',
			'customizer_support'    => true,
			'show_instance_in_rest' => true,
		) );

	}

	/**
	 * Display
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {

		extract( $args );

		// Vars
		$theme_prefix = apply_filters( 'forqy_theme_prefix', 'forqy' );

		$widget_title   = apply_filters( 'widget_title', $instance['title'] );
		$widget_content = apply_filters( 'widget_content', $instance['content'] );

		$widget_link        = $instance['link'] ?? '';
		$widget_link_target = $instance['link_target'] ?? 0;

		// Image
		$widget_image = $instance['image'] ?? '';

		echo $args['before_widget'];

		if ( ! empty( $widget_image ) ) {

			$widget_image_id          = attachment_url_to_postid( $widget_image );
			$widget_image_size        = ! empty( $theme_prefix ) ? $theme_prefix . '-medium' : 'medium';
			$widget_image_src         = wp_get_attachment_image_src( $widget_image_id, $widget_image_size );
			$widget_image_url         = $widget_image_src[0] ?? null;
			$widget_image_width       = $widget_image_src[1] ?? 0;
			$widget_image_height      = $widget_image_src[2] ?? 0;
			$widget_image_placeholder = apply_filters( 'forqy_image_placeholder', $widget_image_width, $widget_image_height );
			?>

            <figure class="fy-widget-image">

				<?php if ( ! empty( $widget_link ) ) { ?>
                    <a href="<?php echo esc_url( $widget_link ); ?>" tabindex="-1" <?php if ( $widget_link_target ) { ?> target="_blank" rel="noopener"<?php } ?>>
                        <img class="fy-lazy js-lazy"
                             alt="<?php echo esc_attr( $widget_title ); ?>"
                             width="<?php echo esc_attr( $widget_image_width ); ?>"
                             height="<?php echo esc_attr( $widget_image_height ); ?>"
                             src="<?php echo esc_attr( $widget_image_placeholder ); ?>"
                             data-src="<?php echo esc_url( $widget_image_url ); ?>">

						<?php if ( function_exists( 'forqy_image_loading' ) ) {
							echo forqy_image_loading();
						}

						if ( $widget_link_target ) { ?>
                            <span class="screen-reader-text"><?php echo esc_html_x( 'New Window', 'link to a new window', 'forqy' ); ?></span>
						<?php } ?>
                    </a>
				<?php } else { ?>
                    <img class="fy-image fy-image-responsive fy-lazy js-lazy"
                         alt="<?php echo esc_attr( $widget_title ); ?>"
                         width="<?php echo esc_attr( $widget_image_width ); ?>"
                         height="<?php echo esc_attr( $widget_image_height ); ?>"
                         src="<?php echo esc_attr( $widget_image_placeholder ); ?>"
                         data-src="<?php echo esc_url( $widget_image_url ); ?>">

					<?php
					if ( function_exists( 'forqy_image_loading' ) ) {
						echo forqy_image_loading();
					}
				} ?>

            </figure>

		<?php }

		if ( ! empty( $widget_title ) ) {
			echo $args['before_title'];

			if ( ! empty( $widget_link ) ) { ?>
                <a href="<?php echo esc_url( $widget_link ); ?>" class="fy-link-underline"<?php if ( $widget_link_target ) { ?> target="_blank" rel="noopener"<?php } ?>>
                    <span><?php echo esc_html( $widget_title );
	                    if ( $widget_link_target ) { ?><span class="screen-reader-text"><?php echo esc_html_x( 'New Window', 'link to a new window', 'forqy' ); ?></span><?php } ?></span>
                </a>
			<?php } else {
				echo esc_html( $widget_title );
			}

			echo $args['after_title'];
		}

		if ( ! empty( $widget_content ) ) { ?>
            <div class="fy-widget-content fy-content">
				<?php echo wp_kses_post( wpautop( do_shortcode( $widget_content ) ) ); ?>
            </div>
		<?php }

		echo $args['after_widget'];

	}

	/**
	 * Update
	 *
	 * @param array $new_instance
	 * @param array $old_instance
	 *
	 * @return array
	 */
	public function update( $new_instance, $old_instance ): array {

		$instance = array();

		$instance['title'] = isset( $new_instance['title'] ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['image'] = isset( $new_instance['image'] ) ? strip_tags( $new_instance['image'] ) : '';

		$instance['content'] = $new_instance['content'] ?? '';

		$instance['link']        = isset( $new_instance['link'] ) ? strip_tags( $new_instance['link'] ) : '';
		$instance['link_target'] = isset( $new_instance['link_target'] ) ? strip_tags( $new_instance['link_target'] ) : '';

		return $instance;
	}

	/**
	 * Form
	 *
	 * @param array $instance
	 *
	 * @return void
	 */
	public function form( $instance ) {

		$instance = wp_parse_args( (array) $instance, array(
			'title'   => '',
			'image'   => '',
			'content' => '',
			'link'    => '',
		) );

		$widget_title = $instance['title'] ?? '';
		$widget_image = $instance['image'] ?? '';

		$widget_content = $instance['content'] ?? '';

		$widget_link        = $instance['link'] ?? '';
		$widget_link_target = $instance['link_target'] ?? '';
		?>

        <p class="fy-media-uploader<?php if ( $instance['image'] != '' ) { ?> uploaded<?php } ?>">
            <label for="<?php echo esc_attr( $this->get_field_id( 'image' ) ); ?>">
				<?php echo esc_html_x( 'Image', 'widget', 'forqy' ); ?>
            </label>

            <img class="fy-media-image-preview js-media-image-preview"
                 src="<?php echo esc_url( $instance['image'] ); ?>" alt="" loading="lazy">

            <input type="hidden"
                   class="widefat js-media-image-input"
                   name="<?php echo esc_attr( $this->get_field_name( 'image' ) ); ?>"
                   id="<?php echo esc_attr( $this->get_field_id( 'image' ) ); ?>"
                   value="<?php echo esc_url( $widget_image ); ?>">

            <input type="button" name="upload_button"
                   class="button button-primary js-media-button-upload"
                   value="<?php echo esc_html_x( 'Select image', 'widget', 'forqy' ); ?>">

            <input type="button" name="remove_button"
                   class="button button-secondary fy-media-button-remove js-media-button-remove"
                   value="<?php echo esc_html_x( 'Remove image', 'widget', 'forqy' ); ?>">
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
				<?php echo esc_html_x( 'Title', 'widget', 'forqy' ); ?>
            </label>

            <input type="text" class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>"
                   value="<?php echo esc_attr( $widget_title ); ?>">
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>">
				<?php echo esc_html_x( 'Content', 'widget', 'forqy' ); ?>
            </label>

            <textarea class="widefat" rows="6" cols="20"
                      id="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>"
                      name="<?php echo esc_attr( $this->get_field_name( 'content' ) ); ?>"><?php echo esc_textarea( $widget_content ); ?></textarea>
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'link' ) ); ?>">
				<?php echo esc_html_x( 'URL', 'widget', 'forqy' ); ?>
            </label>

            <input type="text" class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'link' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'link' ) ); ?>"
                   value="<?php echo esc_attr( $widget_link ); ?>">
        </p>

        <p>
            <input type="checkbox" class="checkbox"
                   id="<?php echo esc_attr( $this->get_field_id( 'link_target' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'link_target' ) ); ?>"<?php if ( $widget_link_target ) { ?> checked="checked"<?php } ?>>

            <label for="<?php echo esc_attr( $this->get_field_id( 'link_target' ) ); ?>">
				<?php echo esc_html_x( 'Open link in a new tab', 'widget', 'forqy' ); ?>
            </label>
        </p>

	<?php }

}
