<?php

/**
 * Portfolio Categories Widget
 *
 * @since 1.0.0
 */
class FORQY_Widget_Categories_Portfolio extends WP_Widget {

	/**
	 * Register
	 */
	public function __construct() {

		parent::__construct( 'forqy_portfolio_categories', defined( 'FORQY_THEME_NAME' ) ? FORQY_THEME_NAME . ' &mdash; ' . esc_html_x( 'Portfolio Categories', 'widget', 'forqy' ) : esc_html_x( 'Portfolio Categories', 'widget', 'forqy' ), array(
			'classname'             => 'widget_categories widget_portfolio_categories',
			'description'           => '',
			'customizer_support'    => true,
			'show_instance_in_rest' => true,
		) );

	}

	/**
	 * Display
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {

		extract( $args );

		$widget_title = apply_filters( 'widget_title', $instance['title'] );

		echo $args['before_widget'];

		if ( $widget_title ) {
			echo $args['before_title'] . esc_html( $widget_title ) . $args['after_title'];
		}

		if ( get_terms( 'category-portfolio' ) ) { ?>

            <nav itemscope itemtype="https://schema.org/SiteNavigationElement" aria-label="<?php esc_attr_e( 'Portfolio Categories', 'forqy' ); ?>">
                <ul><?php wp_list_categories( array(
						'taxonomy'         => 'category-portfolio',
						'orderby'          => 'none',
						'order'            => 'ASC',
						'depth'            => 3,
						'title_li'         => '',
						'show_option_none' => '',
					) ); ?></ul>
            </nav>

		<?php }

		echo $args['after_widget'];

	}

	/**
	 * Update
	 *
	 * @param array $new_instance
	 * @param array $old_instance
	 *
	 * @return array
	 */
	public function update( $new_instance, $old_instance ): array {

		$instance = array();

		$instance['title'] = isset( $new_instance['title'] ) ? strip_tags( $new_instance['title'] ) : '';

		return $instance;

	}

	/**
	 * Form
	 *
	 * @param array $instance
	 *
	 * @return void
	 */
	public function form( $instance ) {

		$instance = wp_parse_args( (array) $instance, array(
			'title' => esc_html__( 'Portfolio Categories', 'forqy' ),
		) );

		$widget_title = $instance['title'] ?? '';
		?>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
				<?php echo esc_html_x( 'Title', 'widget', 'forqy' ); ?>
            </label>

            <input type="text" class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>"
                   value="<?php echo esc_attr( $widget_title ); ?>">
        </p>

	<?php }

}
