<?php

/**
 * Call to Action Widget
 *
 * @since 1.0.0
 */
class FORQY_Widget_Call_to_Action extends WP_Widget {

	/**
	 * Register
	 */
	public function __construct() {

		parent::__construct( 'forqy_call_to_action', defined( 'FORQY_THEME_NAME' ) ? FORQY_THEME_NAME . ' &mdash; ' . esc_html_x( 'Call to Action', 'widget', 'forqy' ) : esc_html_x( 'Call to Action', 'widget', 'forqy' ), array(
			'classname'             => 'widget_call_to_action',
			'description'           => '',
			'customizer_support'    => true,
			'show_instance_in_rest' => true,
		) );

	}

	/**
	 * Display
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {

		extract( $args );

		// Vars
		$theme_prefix = apply_filters( 'forqy_theme_prefix', 'forqy' );

		$widget_title   = apply_filters( 'widget_title', $instance['title'] );
		$widget_content = apply_filters( 'widget_content', $instance['content'] );

		$widget_image = $instance['image'];

		$widget_button        = $instance['button'] ?? '';
		$widget_button_text   = $instance['button_text'] ?? '';
		$widget_button_link   = $instance['button_link'] ?? '';
		$widget_button_target = $instance['button_target'] ?? 0;

		echo $args['before_widget'];

		if ( ! empty( $widget_image ) ) {

			$widget_image_id          = attachment_url_to_postid( $widget_image );
			$widget_image_size        = ! empty( $theme_prefix ) ? $theme_prefix . '-medium' : 'medium';
			$widget_image_src         = wp_get_attachment_image_src( $widget_image_id, $widget_image_size );
			$widget_image_url         = $widget_image_src[0] ?? null;
			$widget_image_width       = $widget_image_src[1] ?? 0;
			$widget_image_height      = $widget_image_src[2] ?? 0;
			$widget_image_placeholder = apply_filters( 'forqy_image_placeholder', $widget_image_width, $widget_image_height );
			$widget_image_filter      = apply_filters( 'forqy_theme_filter', $theme_prefix . '_filter' );
			?>

            <figure class="fy-widget-image fy-image-cover fy-filter">
                <img class="fy-lazy js-lazy fy-filter-<?php echo esc_attr( $widget_image_filter ); ?>"
                     alt="<?php echo esc_attr( $widget_title ); ?>"
                     src="<?php echo esc_attr( $widget_image_placeholder ); ?>"
                     data-src="<?php echo esc_url( $widget_image_url ); ?>">
            </figure>

		<?php }

		if ( ! empty( $widget_title ) ) {
			echo $args['before_title'];

			if ( ! empty( $widget_button_link ) ) { ?>
                <a href="<?php echo esc_url( $widget_button_link ); ?>" class="fy-link-underline"<?php if ( $widget_button_target ) { ?> target="_blank"<?php } ?>>
                    <span><?php echo esc_html( $widget_title );
	                    if ( $widget_button_target ) { ?><span
                                class="screen-reader-text"><?php echo esc_html_x( 'New Window', 'link to a new window', 'forqy' ); ?></span><?php } ?></span>
                </a>
			<?php } else {
				echo esc_html( $widget_title );
			}

			echo $args['after_title'];
		}

		if ( ! empty( $widget_content ) ) { ?>
            <div class="fy-widget-content fy-content">
				<?php echo wp_kses_post( wpautop( do_shortcode( $widget_content ) ) ); ?>
            </div>
		<?php }

		if ( $widget_button && ! empty( $widget_button_text ) ) { ?>
            <div class="fy-widget-footer">
                <a href="<?php echo esc_url( $widget_button_link ); ?>"<?php if ( ! empty( $widget_button_target ) ) { ?> target="_blank"<?php } ?>
                   class="fy-button fy-button-bordered">
					<?php echo esc_html( $widget_button_text ); ?>
                </a>
            </div>
		<?php }

		echo $args['after_widget'];

	}

	/**
	 * Update
	 *
	 * @param array $new_instance
	 * @param array $old_instance
	 *
	 * @return array
	 */
	public function update( $new_instance, $old_instance ): array {

		$instance = array();

		$instance['title'] = isset( $new_instance['title'] ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['image'] = isset( $new_instance['image'] ) ? strip_tags( $new_instance['image'] ) : '';

		$instance['content'] = $new_instance['content'] ?? '';

		$instance['button']        = isset( $new_instance['button'] ) ? strip_tags( $new_instance['button'] ) : '';
		$instance['button_text']   = isset( $new_instance['button_text'] ) ? strip_tags( $new_instance['button_text'] ) : '';
		$instance['button_link']   = isset( $new_instance['button_link'] ) ? strip_tags( $new_instance['button_link'] ) : '';
		$instance['button_target'] = isset( $new_instance['button_target'] ) ? strip_tags( $new_instance['button_target'] ) : '';
		$instance['button_slide']  = isset( $new_instance['button_slide'] ) ? strip_tags( $new_instance['button_slide'] ) : '';

		return $instance;

	}

	/**
	 * Form
	 *
	 * @param array $instance
	 *
	 * @return void
	 */
	public function form( $instance ) {

		$instance = wp_parse_args( $instance, array(
			'title'         => '',
			'image'         => '',
			'button_text'   => esc_html__( 'View more', 'forqy' ),
			'button_link'   => '',
			'button_target' => 0
		) );

		$widget_title         = $instance['title'] ?? '';
		$widget_image         = $instance['image'] ?? '';
		$widget_content       = $instance['content'] ?? '';
		$widget_button        = $instance['button'] ?? '';
		$widget_button_text   = $instance['button_text'] ?? esc_html__( 'View more', 'forqy' );
		$widget_button_link   = $instance['button_link'] ?? '';
		$widget_button_target = $instance['button_target'] ?? '';
		?>

        <p class="fy-media-uploader<?php if ( $instance['image'] != '' ) { ?> uploaded<?php } ?>">
            <label for="<?php echo esc_attr( $this->get_field_id( 'image' ) ); ?>">
				<?php echo esc_html_x( 'Image', 'widget', 'forqy' ); ?>
            </label>

            <img class="fy-media-image-preview js-media-image-preview"
                 src="<?php echo esc_url( $instance['image'] ); ?>" alt="" loading="lazy">

            <input type="hidden"
                   class="widefat js-media-image-input"
                   name="<?php echo esc_attr( $this->get_field_name( 'image' ) ); ?>"
                   id="<?php echo esc_attr( $this->get_field_id( 'image' ) ); ?>"
                   value="<?php echo esc_url( $widget_image ); ?>">

            <input type="button"
                   class="button button-primary js-media-button-upload"
                   name="upload_button"
                   value="<?php echo esc_html_x( 'Select image', 'widget', 'forqy' ); ?>">

            <input type="button"
                   class="button button-secondary fy-media-button-remove js-media-button-remove"
                   name="remove_button"
                   value="<?php echo esc_html_x( 'Remove image', 'widget', 'forqy' ); ?>">
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
				<?php echo esc_html_x( 'Title', 'widget', 'forqy' ); ?>
            </label>

            <input type="text"
                   class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>"
                   value="<?php echo esc_attr( $widget_title ); ?>">
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>">
				<?php echo esc_html_x( 'Subtitle', 'widget', 'forqy' ); ?>
            </label>

            <input type="text"
                   class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'content' ) ); ?>"
                   value="<?php echo esc_attr( $widget_content ); ?>">
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'button_link' ) ); ?>">
				<?php echo esc_html_x( 'URL', 'widget', 'forqy' ); ?>
            </label>

            <input type="text" class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'button_link' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'button_link' ) ); ?>"
                   value="<?php echo esc_attr( $widget_button_link ); ?>">
        </p>

        <p>
            <input type="checkbox" class="checkbox"
                   id="<?php echo esc_attr( $this->get_field_id( 'button_target' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'button_target' ) ); ?>"<?php if ( $widget_button_target ) { ?> checked="checked"<?php } ?>>

            <label for="<?php echo esc_attr( $this->get_field_id( 'button_target' ) ); ?>">
				<?php echo esc_html_x( 'Open link in a new tab', 'widget', 'forqy' ); ?>
            </label>
        </p>

        <p>
            <input type="checkbox" class="checkbox"
                   id="<?php echo esc_attr( $this->get_field_id( 'button' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'button' ) ); ?>"<?php if ( $widget_button ) { ?> checked="checked"<?php } ?>>

            <label for="<?php echo esc_attr( $this->get_field_id( 'button' ) ); ?>">
				<?php echo esc_html_x( 'Show button?', 'widget', 'forqy' ); ?>
            </label>
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'button_text' ) ); ?>">
				<?php echo esc_html_x( 'Button', 'widget', 'forqy' ); ?>
            </label>

            <input type="text" class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'button_text' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'button_text' ) ); ?>"
                   value="<?php echo esc_attr( $widget_button_text ); ?>">
        </p>

	<?php }

}
