<?php

/**
 * About Widget
 *
 * @since 1.0.0
 */
class FORQY_Widget_About extends WP_Widget {

	/**
	 * Register
	 */
	public function __construct() {

		parent::__construct( 'forqy_about', defined( 'FORQY_THEME_NAME' ) ? FORQY_THEME_NAME . ' &mdash; ' . esc_html_x( 'About', 'widget', 'forqy' ) : esc_html_x( 'About', 'widget', 'forqy' ), array(
			'classname'             => 'widget_about',
			'description'           => '',
			'customizer_support'    => true,
			'show_instance_in_rest' => true,
		) );

	}

	/**
	 * Display
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {

		extract( $args );

		// Vars
		$theme_prefix = apply_filters( 'forqy_theme_prefix', 'forqy' );

		$widget_title   = apply_filters( 'widget_title', $instance['title'] );
		$widget_content = apply_filters( 'widget_content', $instance['content'] );
		$widget_image   = $instance['image'] ?? '';

		echo $args['before_widget'];

		if ( $widget_title ) {
			echo $args['before_title'] . esc_html( $widget_title ) . $args['after_title'];
		}

		if ( ! empty( $widget_image ) ) {

			$widget_image_id          = attachment_url_to_postid( $widget_image );
			$widget_image_size        = ! empty( $theme_prefix ) ? $theme_prefix . '-medium' : 'medium';
			$widget_image_src         = wp_get_attachment_image_src( $widget_image_id, $widget_image_size );
			$widget_image_url         = $widget_image_src[0] ?? null;
			$widget_image_width       = $widget_image_src[1] ?? 0;
			$widget_image_height      = $widget_image_src[2] ?? 0;
			$widget_image_placeholder = apply_filters( 'forqy_image_placeholder', $widget_image_width, $widget_image_height );

			// Image Ratio
			if ( $widget_image_width > $widget_image_height ) {
				$widget_image_size = 'landscape';
			} else if ( $widget_image_width < $widget_image_height ) {
				$widget_image_size = 'portrait';
			} else if ( $widget_image_width == $widget_image_height ) {
				$widget_image_size = 'square';
			} else {
				$widget_image_size = 'default';
			} ?>

            <figure class="fy-widget-image fy-image-<?php echo esc_attr( $widget_image_size ); ?> fy-image-cover">

                <img class="fy-lazy js-lazy"
                     alt="<?php echo esc_attr( $widget_title ); ?>"
                     width="<?php echo esc_attr( $widget_image_width ); ?>"
                     height="<?php echo esc_attr( $widget_image_height ); ?>"
                     src="<?php echo esc_attr( $widget_image_placeholder ); ?>"
                     data-src="<?php echo esc_url( $widget_image_url ); ?>">

				<?php if ( function_exists( 'forqy_image_loading' ) ) {
					echo forqy_image_loading();
				} ?>
            </figure>

		<?php }

		if ( isset( $widget_content ) ) { ?>
            <div class="fy-widget-content fy-content">
				<?php echo wp_kses_post( wpautop( do_shortcode( $widget_content ) ) ); ?>
            </div>
		<?php }

		get_template_part( 'templates/social/socials' );

		if ( $instance['button'] && isset( $instance['button_text'] ) && isset( $instance['button_link'] ) ) { ?>

            <div class="fy-widget-button">
                <a href="<?php echo esc_url( $instance['button_link'] ); ?>" class="fy-button fy-button-bordered">
					<?php echo esc_html( $instance['button_text'] ); ?>
                </a>
            </div>

		<?php }

		echo $args['after_widget'];

	}

	/**
	 * Update
	 *
	 * @param array $new_instance
	 * @param array $old_instance
	 *
	 * @return array
	 */
	public function update( $new_instance, $old_instance ): array {

		$instance = array();

		$instance['title'] = isset( $new_instance['title'] ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['image'] = isset( $new_instance['image'] ) ? strip_tags( $new_instance['image'] ) : '';

		$instance['content'] = $new_instance['content'] ?? '';

		$instance['button']      = isset( $new_instance['button'] ) ? strip_tags( $new_instance['button'] ) : '';
		$instance['button_text'] = isset( $new_instance['button_text'] ) ? strip_tags( $new_instance['button_text'] ) : '';
		$instance['button_link'] = isset( $new_instance['button_link'] ) ? strip_tags( $new_instance['button_link'] ) : '';

		return $instance;
	}

	/**
	 * Form
	 *
	 * @param array $instance
	 *
	 * @return void
	 */
	public function form( $instance ) {

		$instance = wp_parse_args( $instance, array(
			'title'       => esc_html__( 'About Us', 'forqy' ),
			'image'       => '',
			'button_text' => esc_html__( 'View more', 'forqy' ),
			'button_link' => '',
		) );

		$widget_title = $instance['title'] ?? '';
		$widget_image = $instance['image'] ?? '';

		$widget_content = $instance['content'] ?? '';

		$widget_button      = $instance['button'] ?? '';
		$widget_button_text = $instance['button_text'] ?? '';
		$widget_button_link = $instance['button_link'] ?? '';
		?>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
				<?php echo esc_html_x( 'Title', 'widget', 'forqy' ); ?>
            </label>

            <input type="text" class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>"
                   value="<?php echo esc_attr( $widget_title ); ?>">
        </p>

        <p class="fy-media-uploader<?php if ( $instance['image'] != '' ) { ?> uploaded<?php } ?>">
            <label for="<?php echo esc_attr( $this->get_field_id( 'image' ) ); ?>">
				<?php echo esc_html_x( 'Image', 'widget', 'forqy' ); ?>
            </label>

            <img class="fy-media-image-preview js-media-image-preview"
                 src="<?php echo esc_url( $instance['image'] ); ?>" alt="" loading="lazy">

            <input type="hidden"
                   class="widefat js-media-image-input"
                   name="<?php echo esc_attr( $this->get_field_name( 'image' ) ); ?>"
                   id="<?php echo esc_attr( $this->get_field_id( 'image' ) ); ?>"
                   value="<?php echo esc_url( $widget_image ); ?>">

            <input type="button"
                   class="button button-primary js-media-button-upload"
                   name="upload_button"
                   value="<?php echo esc_html_x( 'Select image', 'widget', 'forqy' ); ?>">

            <input type="button"
                   class="button button-secondary fy-media-button-remove js-media-button-remove"
                   name="remove_button"
                   value="<?php echo esc_html_x( 'Remove image', 'widget', 'forqy' ); ?>">
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>">
				<?php echo esc_html_x( 'Content', 'widget', 'forqy' ); ?>
            </label>

            <textarea class="widefat"
                      rows="12" cols="20"
                      id="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>"
                      name="<?php echo esc_attr( $this->get_field_name( 'content' ) ); ?>"><?php echo esc_textarea( $widget_content ); ?></textarea>
        </p>

        <p>
            <input type="checkbox"
                   class="checkbox"
                   id="<?php echo esc_attr( $this->get_field_id( 'button' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'button' ) ); ?>"<?php if ( $widget_button ) { ?> checked="checked"<?php } ?>>

            <label for="<?php echo esc_attr( $this->get_field_id( 'button' ) ); ?>">
				<?php echo esc_html_x( 'Show button?', 'widget', 'forqy' ); ?>
            </label>
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'button_text' ) ); ?>">
				<?php echo esc_html_e( 'Button', 'widget', 'forqy' ); ?>
            </label>

            <input type="text"
                   class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'button_text' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'button_text' ) ); ?>"
                   value="<?php echo esc_attr( $widget_button_text ); ?>">
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'button_link' ) ); ?>">
				<?php echo esc_html_x( 'URL', 'widget', 'forqy' ); ?>
            </label>

            <input type="text"
                   class="widefat"
                   id="<?php echo esc_attr( $this->get_field_id( 'button_link' ) ); ?>"
                   name="<?php echo esc_attr( $this->get_field_name( 'button_link' ) ); ?>"
                   value="<?php echo esc_attr( $widget_button_link ); ?>">
        </p>

	<?php }

}
