<?php

/**
 * FORQY Types
 *
 * @version 1.1.5
 * @author  FORQY
 * @url     https://forqy.website/
 * @license GPL-3.0-or-later
 */

// Meta
require_once dirname( __FILE__ ) . '/inc/meta.php';
// Sanitize
require_once dirname( __FILE__ ) . '/inc/sanitize.php';
// Taximage
require_once dirname( __FILE__ ) . '/inc/taximage.php';


// Taxonomy - Image
require_once dirname( __FILE__ ) . '/taxonomy/image/image.php';
// Metabox - Gallery
require_once dirname( __FILE__ ) . '/metabox/gallery.php';
// Customize - Slugs
require_once dirname( __FILE__ ) . '/customize/slugs.php';


if ( ! function_exists( 'forqy_types_styles' ) ) {

	/**
	 * Styles
	 */
	function forqy_types_styles() {

		wp_register_style( 'forqy-types', plugins_url( 'assets/css/types.css', __FILE__ ), array() );
		wp_enqueue_style( 'forqy-types' );

	}

	add_action( 'admin_enqueue_scripts', 'forqy_types_styles', 200 );

}

if ( ! function_exists( 'forqy_types_scripts' ) ) {

	/**
	 * Scripts
	 */
	function forqy_types_scripts() {

		if ( ! did_action( 'wp_enqueue_media' ) ) {
			wp_enqueue_media();
		}

		wp_enqueue_script( 'forqy-gallery', plugins_url( 'assets/js/gallery.js', __FILE__ ), array(
			'jquery',
			'jquery-ui-sortable',
		) );

	}

	add_action( 'admin_enqueue_scripts', 'forqy_types_scripts' );

}
