<?php

/*

Slide Type

*/

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;

/*
====================================================================================================
Register Type
====================================================================================================
*/

if ( ! function_exists( 'forqy_type_slide_register' ) ) {

	function forqy_type_slide_register() {

		if ( current_theme_supports( 'forqy-slide' ) ) {

			// New Version with a Gutenberg Support

			register_post_type( 'slide', array(
				'labels'              => array(
					'name'                     => esc_html_x( 'Slideshow', 'type', 'forqy' ),
					'menu_name'                => esc_html_x( 'Slideshow', 'type', 'forqy' ),
					'singular_name'            => esc_html_x( 'Slide', 'type', 'forqy' ),
					'name_admin_bar'           => esc_html_x( 'Slide', 'type', 'forqy' ),
					'all_items'                => esc_html_x( 'All Slides', 'type', 'forqy' ),
					'add_new'                  => esc_html_x( 'Add New Slide', 'type', 'forqy' ),
					'add_new_item'             => esc_html_x( 'Add New Slide', 'type', 'forqy' ),
					'edit_item'                => esc_html_x( 'Edit Slide', 'type', 'forqy' ),
					'new_item'                 => esc_html_x( 'New Slide', 'type', 'forqy' ),
					'view_item'                => esc_html_x( 'View Slide', 'type', 'forqy' ),
					'view_items'               => esc_html_x( 'View Slides', 'type', 'forqy' ),
					'search_items'             => esc_html_x( 'Search Slides', 'type', 'forqy' ),
					'not_found'                => esc_html_x( 'No Slides', 'type', 'forqy' ),
					'not_found_in_trash'       => esc_html_x( 'No Slides Found in Trash', 'type', 'forqy' ),
					'archives'                 => esc_html_x( 'Slide Archives', 'type', 'forqy' ),
					'attributes'               => esc_html_x( 'Slide Attributes', 'type', 'forqy' ),
					'item_published'           => esc_html_x( 'Slide published.', 'type', 'forqy' ),
					'item_published_privately' => esc_html_x( 'Slide published privately.', 'type', 'forqy' ),
					'item_scheduled'           => esc_html_x( 'Slide scheduled.', 'type', 'forqy' ),
					'item_updated'             => esc_html_x( 'Slide updated.', 'type', 'forqy' ),
				),
				'public'              => true,
				'show_ui'             => true,
				'show_in_nav_menus'   => false,
				'show_in_admin_bar'   => false,
				'show_in_rest'        => true,
				'capability_type'     => 'page',
				'hierarchical'        => false,
				'has_archive'         => false,
				'exclude_from_search' => true,
				'publicly_queryable'  => false,
				'query_var'           => true,
				'rewrite'             => array(
					'slug'       => 'slide',
					'with_front' => false,
				),
				'menu_position'       => 30,
				'menu_icon'           => 'data:image/svg+xml;base64,' . base64_encode( '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path fill="rgba(240,246,252,.6)" d="M2,3v14h16V3H2z M16,9.2l-0.6-0.6L14,7.2l-1.4,1.4L14,10l-1.4,1.4l1.4,1.4l1.4-1.4l0.6-0.6V15H4v-4.2l2,2 l1.4-1.4L6,10l1.4-1.4L6,7.2l-2,2V5h12V9.2z"/></svg>' ),
				'supports'            => array(
					'title',
					'thumbnail',
					'editor',
					'page-attributes',
					'author',
				),
			) );

		} else {

			register_post_type( 'slide', array(
				'labels'              => array(
					'name'               => esc_html_x( 'Slideshow', 'type', 'forqy' ),
					'menu_name'          => esc_html_x( 'Slideshow', 'type', 'forqy' ),
					'singular_name'      => esc_html_x( 'Slide', 'type', 'forqy' ),
					'name_admin_bar'     => esc_html_x( 'Slide', 'type', 'forqy' ),
					'all_items'          => esc_html_x( 'All Slides', 'type', 'forqy' ),
					'add_new'            => esc_html_x( 'Add New Slide', 'type', 'forqy' ),
					'add_new_item'       => esc_html_x( 'Add New Slide', 'type', 'forqy' ),
					'edit_item'          => esc_html_x( 'Edit Slide', 'type', 'forqy' ),
					'new_item'           => esc_html_x( 'New Slide', 'type', 'forqy' ),
					'view_item'          => esc_html_x( 'View Slide', 'type', 'forqy' ),
					'view_items'         => esc_html_x( 'View Slides', 'type', 'forqy' ),
					'search_items'       => esc_html_x( 'Search Slides', 'type', 'forqy' ),
					'not_found'          => esc_html_x( 'No Slides', 'type', 'forqy' ),
					'not_found_in_trash' => esc_html_x( 'No Slides Found in Trash', 'type', 'forqy' ),
				),
				'public'              => true,
				'show_ui'             => true,
				'show_in_nav_menus'   => false,
				'show_in_admin_bar'   => false,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'exclude_from_search' => true,
				'publicly_queryable'  => false,
				'query_var'           => true,
				'rewrite'             => array(
					'slug'       => 'slide',
					'with_front' => false,
				),
				'menu_position'       => 30,
				'menu_icon'           => 'data:image/svg+xml;base64,' . base64_encode( '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path fill="rgba(240,246,252,.6)" d="M2,3v14h16V3H2z M16,9.2l-0.6-0.6L14,7.2l-1.4,1.4L14,10l-1.4,1.4l1.4,1.4l1.4-1.4l0.6-0.6V15H4v-4.2l2,2 l1.4-1.4L6,10l1.4-1.4L6,7.2l-2,2V5h12V9.2z"/></svg>' ),
				'supports'            => array(
					'title',
					'thumbnail',
					'author',
				),
			) );

		}

	}

	add_action( 'init', 'forqy_type_slide_register' );

}

/*
====================================================================================================
Type Allowed Blocks
====================================================================================================
*/

if ( ! function_exists( 'forqy_type_slide_blocks' ) ) {

	function forqy_type_slide_blocks( $allowed_blocks ) {

		if ( get_post_type( get_the_ID() ) === 'slide' ) {
			$allowed_blocks = array(
				'core/heading',
				'core/paragraph',
				'core/list',
				'core/columns',
				'core/audio',
				'core/image',
				'core/button',
				'core/buttons',
				'core/shortcode',
			);
		}

		return $allowed_blocks;

	}

	add_filter( 'allowed_block_types_all', 'forqy_type_slide_blocks', 10, 2 );

	// Backward compatibility before WP 5.8
	if ( ! function_exists( 'get_allowed_block_types' ) ) {
		add_filter( 'allowed_block_types', 'forqy_type_slide_blocks', 10, 2 );
	}

}

/*
====================================================================================================
Admin Listing Columns
====================================================================================================
*/

/*
----------------------------------------------------------------------------------------------------
Type Columns Edit
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_slide_columns' ) ) {

	function forqy_type_slide_columns(): array {

		return array(
			'cb'        => "<input type=\"checkbox\">",
			'thumbnail' => '',
			'title'     => esc_html_x( 'Title', 'type', 'forqy' ),
			'author'    => esc_html_x( 'Author', 'type', 'forqy' ),
			'date'      => esc_html_x( 'Date', 'type', 'forqy' ),
		);

	}

	add_filter( 'manage_edit-slide_columns', 'forqy_type_slide_columns' );

}

/*
----------------------------------------------------------------------------------------------------
Type Columns Content
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_slide_columns_content' ) ) {

	function forqy_type_slide_columns_content( $column ) {

		switch ( $column ) {

			// Thumbnail
			case 'thumbnail':

				$video     = forqy_meta( 'fy_video' );
				$thumbnail = get_the_post_thumbnail( get_the_ID(), array( 60, 60 ) );

				if ( has_post_thumbnail() ) {
					if ( ! empty( $video ) ) {
						echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail video">' . $thumbnail . '</a>';
					} else {
						echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail">' . $thumbnail . '</a>';
					}
				} else if ( ! empty( $video ) ) {
					echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail empty video"></a>';
				} else {
					echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail empty"></a>';
				}

				break;

		}

	}

	add_action( 'manage_slide_posts_custom_column', 'forqy_type_slide_columns_content', 10, 1 );

}

/*
----------------------------------------------------------------------------------------------------
Type Columns Sorting
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_slide_columns_sorting' ) ) {

	function forqy_type_slide_columns_sorting(): array {

		return array(
			'title'  => 'title',
			'author' => 'author',
			'date'   => 'date',
		);

	}

	add_filter( 'manage_edit-slide_sortable_columns', 'forqy_type_slide_columns_sorting' );

}

/*
----------------------------------------------------------------------------------------------------
Type Columns Default Sort
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_slide_columns_sorting_default' ) ) {

	function forqy_type_slide_columns_sorting_default( $query ) {

		if ( is_admin() ) {

			if ( isset( $query->query['post_type'] ) ) {

				// Get the Post Type from the Query
				$type = $query->query['post_type'];

				if ( ! empty( $type ) ) {

					if ( $type == 'slide' && ! isset( $_GET['order'] ) ) {
						$query->set( 'orderby', array(
							'menu_order' => 'ASC',
							'date'       => 'DESC',
						) );
					}

				}

			}

		}

	}

	add_filter( 'pre_get_posts', 'forqy_type_slide_columns_sorting_default' );

}
