<?php

/*

Review Type

*/

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;

/*
====================================================================================================
Register Type
====================================================================================================
*/

if ( ! function_exists( 'forqy_type_review_register' ) ) {

	function forqy_type_review_register() {

		register_post_type( 'review', array(
			'labels'              => array(
				'name'                     => esc_html_x( 'Reviews', 'type', 'forqy' ),
				'menu_name'                => esc_html_x( 'Reviews', 'type', 'forqy' ),
				'singular_name'            => esc_html_x( 'Review', 'type', 'forqy' ),
				'name_admin_bar'           => esc_html_x( 'Review', 'type', 'forqy' ),
				'all_items'                => esc_html_x( 'All Reviews', 'type', 'forqy' ),
				'add_new'                  => esc_html_x( 'Add New Review', 'type', 'forqy' ),
				'add_new_item'             => esc_html_x( 'Add New Review', 'type', 'forqy' ),
				'edit_item'                => esc_html_x( 'Edit Review', 'type', 'forqy' ),
				'new_item'                 => esc_html_x( 'New Review', 'type', 'forqy' ),
				'view_item'                => esc_html_x( 'View Review', 'type', 'forqy' ),
				'view_items'               => esc_html_x( 'View Review', 'type', 'forqy' ),
				'search_items'             => esc_html_x( 'Search Reviews', 'type', 'forqy' ),
				'not_found'                => esc_html_x( 'No Reviews', 'type', 'forqy' ),
				'not_found_in_trash'       => esc_html_x( 'No Reviews Found in Trash', 'type', 'forqy' ),
				'archives'                 => esc_html_x( 'Review Archives', 'type', 'forqy' ),
				'attributes'               => esc_html_x( 'Review Attributes', 'type', 'forqy' ),
				'item_published'           => esc_html_x( 'Review published.', 'type', 'forqy' ),
				'item_published_privately' => esc_html_x( 'Review published privately.', 'type', 'forqy' ),
				'item_scheduled'           => esc_html_x( 'Review scheduled.', 'type', 'forqy' ),
				'item_updated'             => esc_html_x( 'Review updated.', 'type', 'forqy' ),
			),
			'public'              => true,
			'show_ui'             => true,
			'show_in_nav_menus'   => true,
			'show_in_admin_bar'   => true,
			'show_in_rest'        => true,
			'capability_type'     => 'post',
			'hierarchical'        => false,
			'has_archive'         => false,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'query_var'           => true,
			'rewrite'             => false,
			'menu_position'       => 36,
			'menu_icon'           => 'data:image/svg+xml;base64,' . base64_encode( '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path fill="rgba(240,246,252,.6)" d="M2,3v14h3v3h2l4.7-3H18V3H2z M16,15h-4.9L7,17.6V15H4V5h12V15z M14,7H6v2h8V7z M14,11H6v2h8V11z"/></svg>' ),
			'supports'            => array(
				'title',
				'editor',
				'author',
				'revisions',
			),
		) );

	}

	add_action( 'init', 'forqy_type_review_register' );

}

/*
====================================================================================================
Admin Listing Columns
====================================================================================================
*/

/*
----------------------------------------------------------------------------------------------------
Type Columns Edit
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_review_columns' ) ) {

	function forqy_type_review_columns(): array {

		return array(
			'cb'     => "<input type=\"checkbox\">",
			'title'  => esc_html_x( 'Title', 'type', 'forqy' ),
			'author' => esc_html_x( 'Author', 'type', 'forqy' ),
			'date'   => esc_html_x( 'Date', 'type', 'forqy' ),
		);

	}

	add_filter( 'manage_edit-video_columns', 'forqy_type_review_columns' );

}
