<?php

/*

Reservation Type

*/

global $pagenow;

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;

/*
====================================================================================================
Register Type
====================================================================================================
*/

if ( ! function_exists( 'forqy_type_reservation_register' ) ) {

	function forqy_type_reservation_register() {

		register_post_type( 'reservation', array(
			'labels'              => array(
				'name'                     => esc_html_x( 'Reservations', 'type', 'forqy' ),
				'menu_name'                => esc_html_x( 'Reservations', 'type', 'forqy' ),
				'singular_name'            => esc_html_x( 'Reservation', 'type', 'forqy' ),
				'name_admin_bar'           => esc_html_x( 'Reservation', 'type', 'forqy' ),
				'all_items'                => esc_html_x( 'All Reservations', 'type', 'forqy' ),
				'add_new'                  => esc_html_x( 'Add New Reservation', 'type', 'forqy' ),
				'add_new_item'             => esc_html_x( 'Add New Reservation', 'type', 'forqy' ),
				'edit_item'                => esc_html_x( 'Edit Reservation', 'type', 'forqy' ),
				'new_item'                 => esc_html_x( 'New Reservation', 'type', 'forqy' ),
				'view_item'                => esc_html_x( 'View Reservation', 'type', 'forqy' ),
				'view_items'               => esc_html_x( 'View Reservations', 'type', 'forqy' ),
				'search_items'             => esc_html_x( 'Search Reservations', 'type', 'forqy' ),
				'not_found'                => esc_html_x( 'No Reservations', 'type', 'forqy' ),
				'not_found_in_trash'       => esc_html_x( 'No Reservations Found in Trash', 'type', 'forqy' ),
				'archives'                 => esc_html_x( 'Reservation Archives', 'type', 'forqy' ),
				'attributes'               => esc_html_x( 'Reservation Attributes', 'type', 'forqy' ),
				'item_published'           => esc_html_x( 'Reservation saved.', 'type', 'forqy' ),
				'item_published_privately' => esc_html_x( 'Reservation saved.', 'type', 'forqy' ),
				'item_scheduled'           => esc_html_x( 'Reservation scheduled.', 'type', 'forqy' ),
				'item_updated'             => esc_html_x( 'Reservation updated.', 'type', 'forqy' ),
			),
			'public'              => false,
			'show_ui'             => true,
			'show_in_nav_menus'   => false,
			'show_in_admin_bar'   => false,
			'show_in_rest'        => true,
			'capability_type'     => 'post',
			'hierarchical'        => false,
			'has_archive'         => false,
			'exclude_from_search' => true,
			'publicly_queryable'  => false,
			'query_var'           => true,
			'can_export'          => false,
			'rewrite'             => array(
				'slug'       => 'reservation',
				'with_front' => false,
			),
			'menu_position'       => 40,
			'menu_icon'           => 'data:image/svg+xml;base64,' . base64_encode( '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path fill="rgba(240,246,252,.6)" d="M9,9.6l-2.7,2.7l1.4,1.4l3.3-3.3V5H9V9.6z M10,2c-4.4,0-8,3.6-8,8s3.6,8,8,8s8-3.6,8-8S14.4,2,10,2z M10,16 c-3.3,0-6-2.7-6-6s2.7-6,6-6s6,2.7,6,6S13.3,16,10,16z"/></svg>' ),
			'supports'            => array(
				'author',
			),
		) );

	}

	add_action( 'init', 'forqy_type_reservation_register' );

}

/*
====================================================================================================
Change "Publish" Button
====================================================================================================
*/

if ( ! function_exists( 'forqy_type_reservation_publish_button' ) ) {

	function forqy_type_reservation_publish_button( $translation, $text ) {

		if ( 'reservation' == get_post_type() ) {
			if ( $text == 'Publish' ) {
				return _x( 'Save', 'type', 'forqy' );
			}
		}

		return $translation;
	}

	add_filter( 'gettext', 'forqy_type_reservation_publish_button', 10, 2 );

}

/*
====================================================================================================
Admin Navigation Notification Bubble
====================================================================================================
*/

if ( ! function_exists( 'forqy_type_reservation_notification_bubble' ) ) {

	function forqy_type_reservation_notification_bubble() {
		global $menu;

		$post_types = array( 'reservation' );

		foreach ( $post_types as $type ) {
			$post_count = forqy_type_get_pending_reservations( $type );
			if ( ! empty( $post_count ) ) {
				foreach ( (array) $menu as $key => $parent_menu ) {
					if ( $parent_menu[2] == 'edit.php?post_type=' . $type ) {
						$menu[ $key ][0] = $menu[ $key ][0] . '&nbsp;<span class="awaiting-mod"><span class="pending-count">' . $post_count . '</span></span>';
					}
				}
			}
		}
	}

	function forqy_type_get_pending_reservations( $type ) {

		$query = new WP_Query( array(
			'post_type'  => $type,
			'meta_key'   => 'fy_reservation_status',
			'meta_value' => 'pending',
		) );

		return $query->found_posts;

	}

	add_action( 'admin_menu', 'forqy_type_reservation_notification_bubble' );

}

/*
====================================================================================================
Admin Listing Columns
====================================================================================================
*/

/*
----------------------------------------------------------------------------------------------------
Type Columns Edit
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_reservation_columns' ) ) {

	function forqy_type_reservation_columns(): array {

		return array(
			'cb'                  => "<input type=\"checkbox\">",
			'title'               => esc_html_x( 'Date', 'type', 'forqy' ),
			'reservation_time'    => esc_html_x( 'Time', 'type', 'forqy' ),
			'reservation_status'  => esc_html_x( 'Status', 'type', 'forqy' ),
			'reservation_persons' => esc_html_x( 'Guests', 'type', 'forqy' ),
			'reservation_name'    => esc_html_x( 'Name', 'type', 'forqy' ),
			'reservation_email'   => esc_html_x( 'Email', 'type', 'forqy' ),
			'reservation_phone'   => esc_html_x( 'Phone', 'type', 'forqy' ),
			'author'              => esc_html_x( 'Author', 'type', 'forqy' ),
			'date'                => esc_html_x( 'Created', 'type', 'forqy' ),
		);

	}

	add_filter( 'manage_edit-reservation_columns', 'forqy_type_reservation_columns' );

}

/*
----------------------------------------------------------------------------------------------------
Type Columns Content
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_reservation_columns_content' ) ) {

	function forqy_type_reservation_columns_content( $column ) {

		switch ( $column ) {

			// Time
			case 'reservation_time':

				$reservation_time = forqy_meta( 'fy_reservation_time' );

				if ( ! empty( $reservation_time ) ) {
					printf( '%s', $reservation_time );
				}

				break;

			// Status
			case 'reservation_status':

				$reservation_status = forqy_meta( 'fy_reservation_status' );

				if ( ! empty( $reservation_status ) ) {
					?>
                    <span class="reservation-status <?php echo esc_attr( $reservation_status ); ?>">
						<?php if ( $reservation_status == 'pending' ) {
							echo esc_html_x( 'Pending', 'type', 'forqy' );
						} else if ( $reservation_status == 'confirmed' ) {
							echo esc_html_x( 'Confirmed', 'type', 'forqy' );
						} else if ( $reservation_status == 'canceled' ) {
							echo esc_html_x( 'Canceled', 'type', 'forqy' );
						} else if ( $reservation_status == 'closed' ) {
							echo esc_html_x( 'Closed', 'type', 'forqy' );
						} ?>
					</span>
					<?php
				}

				break;

			// Persons
			case 'reservation_persons':

				$reservation_persons = forqy_meta( 'fy_reservation_persons' );

				if ( ! empty( $reservation_persons ) ) {
					echo esc_html( $reservation_persons );
				}

				break;

			// Name
			case 'reservation_name':

				$reservation_name = forqy_meta( 'fy_reservation_name' );

				if ( ! empty( $reservation_name ) ) {
					echo esc_html( $reservation_name );
				}

				break;

			// Email
			case 'reservation_email':

				$reservation_email = forqy_meta( 'fy_reservation_email' );

				if ( ! empty( $reservation_email ) ) {
					echo esc_html( $reservation_email );
				}

				break;

			// Phone
			case 'reservation_phone':

				$reservation_phone = forqy_meta( 'fy_reservation_phone' );

				if ( ! empty( $reservation_phone ) ) {
					echo esc_html( $reservation_phone );
				}

				break;

		}

	}

	add_action( 'manage_reservation_posts_custom_column', 'forqy_type_reservation_columns_content', 10, 1 );

}

/*
----------------------------------------------------------------------------------------------------
Type Column Title
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_reservation_title' ) ) {

	function forqy_type_reservation_title( $title, $id ) {

		if ( is_admin() ) {
			if ( get_post_type( $id ) == 'reservation' ) {
				return esc_html( forqy_meta( 'fy_reservation_date' ) );
			} else {
				return $title;
			}
		}
	}

	function forqy_type_reservation_title_filter() {
		global $pagenow;

		if ( is_admin() ) {
			if ( $pagenow == 'edit.php' && get_post_type() == 'reservation' ) {
				add_filter( 'the_title', 'forqy_type_reservation_title', 10, 2 );
			}
		}
	}

	add_action( 'admin_head-edit.php', 'forqy_type_reservation_title_filter' );

}

/*
----------------------------------------------------------------------------------------------------
Type Columns Orderby
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_reservation_columns_orderby' ) ) {

	function forqy_type_reservation_columns_orderby( $query ) {

		if ( is_admin() ) {

			if ( isset( $query->query['post_type'] ) ) {

				// Get the post type from the query
				$type    = $query->query['post_type'];
				$orderby = $query->get( 'orderby' );

				if ( ! empty( $type ) ) {

					// Default
					if ( $type == 'reservation' && ! isset( $_GET['order'] ) ) {
						// Sort descending by default if is not set
						$query->set( 'orderby', array(
							'date' => 'DESC',
						) );
					}
					// By Date
					if ( $type == 'reservation' && $orderby == 'title' ) {
						$query->set( 'meta_key', 'fy_reservation_date' );
						$query->set( 'orderby', 'meta_value' );
					}
					// By Status
					if ( $type == 'reservation' && $orderby == 'reservation_status' ) {
						$query->set( 'meta_key', 'fy_reservation_status' );
						$query->set( 'orderby', 'meta_value' );
					}

				}

			}

		}

	}

	add_action( 'pre_get_posts', 'forqy_type_reservation_columns_orderby' );

}

/*
----------------------------------------------------------------------------------------------------
Type Columns Sorting
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_reservation_columns_sorting' ) ) {

	function forqy_type_reservation_columns_sorting(): array {

		return array(
			'title'              => 'reservation_date',
			'reservation_status' => 'reservation_status',
			'date'               => 'date',
		);

	}

	add_filter( 'manage_edit-reservation_sortable_columns', 'forqy_type_reservation_columns_sorting' );

}
