<?php

/*

Portfolio Type

*/

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;

/*
====================================================================================================
Register Type
====================================================================================================
*/

if ( ! function_exists( 'forqy_type_project_register' ) ) {

	function forqy_type_project_register() {

		register_post_type( 'project', array(
			'labels'              => array(
				'name'                     => esc_html_x( 'Portfolio', 'type', 'forqy' ),
				'menu_name'                => esc_html_x( 'Portfolio', 'type', 'forqy' ),
				'singular_name'            => esc_html_x( 'Portfolio', 'type', 'forqy' ),
				'name_admin_bar'           => esc_html_x( 'Project', 'type', 'forqy' ),
				'all_items'                => esc_html_x( 'All Projects', 'type', 'forqy' ),
				'add_new'                  => esc_html_x( 'Add New Project', 'type', 'forqy' ),
				'add_new_item'             => esc_html_x( 'Add New Project', 'type', 'forqy' ),
				'edit_item'                => esc_html_x( 'Edit Project', 'type', 'forqy' ),
				'new_item'                 => esc_html_x( 'New Project', 'type', 'forqy' ),
				'view_item'                => esc_html_x( 'View Project', 'type', 'forqy' ),
				'view_items'               => esc_html_x( 'View Projects', 'type', 'forqy' ),
				'search_items'             => esc_html_x( 'Search Projects', 'type', 'forqy' ),
				'not_found'                => esc_html_x( 'No Projects', 'type', 'forqy' ),
				'not_found_in_trash'       => esc_html_x( 'No Projects Found in Trash', 'type', 'forqy' ),
				'archives'                 => esc_html_x( 'Project Archives', 'type', 'forqy' ),
				'attributes'               => esc_html_x( 'Project Attributes', 'type', 'forqy' ),
				'item_published'           => esc_html_x( 'Project published.', 'type', 'forqy' ),
				'item_published_privately' => esc_html_x( 'Project published privately.', 'type', 'forqy' ),
				'item_scheduled'           => esc_html_x( 'Project scheduled.', 'type', 'forqy' ),
				'item_updated'             => esc_html_x( 'Project updated.', 'type', 'forqy' ),
			),
			'public'              => true,
			'show_ui'             => true,
			'show_in_nav_menus'   => true,
			'show_in_admin_bar'   => true,
			'show_in_rest'        => true,
			'capability_type'     => 'post',
			'hierarchical'        => true,
			'has_archive'         => false,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'query_var'           => true,
			'rewrite'             => array(
				'slug'       => get_theme_mod( 'fy_slug_project', 'project' ),
				'with_front' => false,
			),
			'menu_position'       => 31,
			'menu_icon'           => 'data:image/svg+xml;base64,' . base64_encode( '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path fill="rgba(240,246,252,.6)" d="M14,4V3H6v1H2v13h16V4H14z M16,15H4v-2h4v1h4v-1h4V15z M16,11h-4v-1H8v1H4V6h12V11z"/></svg>' ),
			'supports'            => array(
				'title',
				'editor',
				'author',
				'excerpt',
				'thumbnail',
				'revisions',
				'page-attributes',
			),
		) );

	}

	add_action( 'init', 'forqy_type_project_register' );

}

/*
====================================================================================================
Admin Listing Columns
====================================================================================================
*/

/*
----------------------------------------------------------------------------------------------------
Type Columns Edit
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_project_columns' ) ) {

	function forqy_type_project_columns(): array {

		return array(
			'cb'                 => "<input type=\"checkbox\">",
			'thumbnail'          => '',
			'title'              => esc_html_x( 'Title', 'type', 'forqy' ),
			'project_categories' => esc_html_x( 'Categories', 'type', 'forqy' ),
			'project_client'     => esc_html_x( 'Client', 'type', 'forqy' ),
			'author'             => esc_html_x( 'Author', 'type', 'forqy' ),
			'date'               => esc_html_x( 'Date', 'type', 'forqy' ),
		);

	}

	add_filter( 'manage_edit-project_columns', 'forqy_type_project_columns' );

}

/*
----------------------------------------------------------------------------------------------------
Post Type Columns Content
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_project_columns_content' ) ) {

	function forqy_type_project_columns_content( $column ) {
		global $post;

		switch ( $column ) {

			// Thumbnail
			case 'thumbnail':

				$video     = forqy_meta( 'fy_video' );
				$thumbnail = get_the_post_thumbnail( get_the_ID(), array( 60, 60 ) );

				if ( has_post_thumbnail() ) {
					if ( ! empty( $video ) ) {
						echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail video">' . $thumbnail . '</a>';
					} else {
						echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail">' . $thumbnail . '</a>';
					}
				} else if ( ! empty( $video ) ) {
					echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail empty video"></a>';
				} else {
					echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail empty"></a>';
				}

				break;

			// Categories
			case 'project_categories':

				$categories = get_the_terms( $post->ID, 'category-portfolio' );

				if ( ! empty( $categories ) ) {

					foreach ( $categories as $category ) {
						echo '<a href="' . get_edit_term_link( $category ) . '">';
						echo esc_html( $category->name );
						echo '</a>';
						if ( next( $categories ) ) {
							echo ', ';
						}
					}
				}

				break;

			// Client
			case 'project_client':

				$project_client = forqy_meta( 'fy_project_client' );

				if ( ! empty( $project_client ) ) {
					echo esc_html( $project_client );
				}

				break;

		}

	}

	add_action( 'manage_project_posts_custom_column', 'forqy_type_project_columns_content', 10, 1 );

}

/*
----------------------------------------------------------------------------------------------------
Type Columns Sorting
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_project_columns_sorting' ) ) {

	function forqy_type_project_columns_sorting(): array {

		return array(
			'title'          => 'title',
			'author'         => 'author',
			'project_client' => 'project_client',
			'date'           => 'date',
		);

	}

	add_filter( 'manage_edit-project_sortable_columns', 'forqy_type_project_columns_sorting' );

}

/*
----------------------------------------------------------------------------------------------------
Type Columns Default Sort
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_project_columns_sorting_default' ) ) {

	function forqy_type_project_columns_sorting_default( $query ) {

		if ( is_admin() ) {

			if ( isset( $query->query['post_type'] ) ) {

				// Get the post type from the query
				$type = $query->query['post_type'];

				if ( ! empty( $type ) ) {

					if ( $type == 'project' && ! isset( $_GET['order'] ) ) {
						$query->set( 'orderby', array(
							'menu_order' => 'ASC',
							'date'       => 'DESC',
						) );
					}

				}

			}

		}

	}

	add_filter( 'pre_get_posts', 'forqy_type_project_columns_sorting_default' );

}
