<?php

/*

Menu Type

*/

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;

/*
====================================================================================================
Register Type
====================================================================================================
*/

if ( ! function_exists( 'forqy_type_menu_register' ) ) {

	function forqy_type_menu_register() {

		register_post_type( 'menu', array(
			'labels'              => array(
				'name'                     => esc_html_x( 'Menu', 'type', 'forqy' ),
				'menu_name'                => esc_html_x( 'Menu', 'type', 'forqy' ),
				'singular_name'            => esc_html_x( 'Menu', 'type', 'forqy' ),
				'name_admin_bar'           => esc_html_x( 'Menu Item', 'type', 'forqy' ),
				'all_items'                => esc_html_x( 'All Items', 'type', 'forqy' ),
				'add_new'                  => esc_html_x( 'Add New Item', 'type', 'forqy' ),
				'add_new_item'             => esc_html_x( 'Add New Item', 'type', 'forqy' ),
				'edit_item'                => esc_html_x( 'Edit Item', 'type', 'forqy' ),
				'new_item'                 => esc_html_x( 'New Item', 'type', 'forqy' ),
				'view_item'                => esc_html_x( 'View Item', 'type', 'forqy' ),
				'view_items'               => esc_html_x( 'View Items', 'type', 'forqy' ),
				'search_items'             => esc_html_x( 'Search Items', 'type', 'forqy' ),
				'not_found'                => esc_html_x( 'No Items', 'type', 'forqy' ),
				'not_found_in_trash'       => esc_html_x( 'No Items Found in Trash', 'type', 'forqy' ),
				'archives'                 => esc_html_x( 'Item Archives', 'type', 'forqy' ),
				'attributes'               => esc_html_x( 'Item Attributes', 'type', 'forqy' ),
				'item_published'           => esc_html_x( 'Item published.', 'type', 'forqy' ),
				'item_published_privately' => esc_html_x( 'Item published privately.', 'type', 'forqy' ),
				'item_scheduled'           => esc_html_x( 'Item scheduled.', 'type', 'forqy' ),
				'item_updated'             => esc_html_x( 'Item updated.', 'type', 'forqy' ),
			),
			'public'              => true,
			'show_ui'             => true,
			'show_in_nav_menus'   => true,
			'show_in_admin_bar'   => true,
			'show_in_rest'        => true,
			'capability_type'     => 'post',
			'hierarchical'        => true,
			'has_archive'         => false,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'query_var'           => true,
			'rewrite'             => array(
				'slug'       => get_theme_mod( 'fy_slug_menu', 'item' ),
				'with_front' => false,
			),
			'menu_position'       => 32,
			'menu_icon'           => 'data:image/svg+xml;base64,' . base64_encode( '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path fill="rgba(240,246,252,.6)" d="M17,3h-1l-6,4L4,3H3L2,4v10.2L9,19h2l7-4.8V4L17,3z M9,16.5l-5-3.3V5.5L9,9V16.5z M16,13.1l-5,3.3V9l5-3.5 V13.1z M15,7.8l-3,2v2.4l3-2V7.8z"/></svg>' ),
			'supports'            => array(
				'title',
				'editor',
				'author',
				'excerpt',
				'thumbnail',
				'revisions',
			),
			'taxonomies'          => array(
				'ingredient',
				'section',
			),
		) );

	}

	add_action( 'init', 'forqy_type_menu_register' );

}

/*
====================================================================================================
Admin Listing Columns
====================================================================================================
*/

/*
----------------------------------------------------------------------------------------------------
Type Columns Edit
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_menu_columns' ) ) {

	function forqy_type_menu_columns(): array {

		return array(
			'cb'               => "<input type=\"checkbox\">",
			'thumbnail'        => '',
			'title'            => esc_html_x( 'Title', 'type', 'forqy' ),
			'menu_prices'      => esc_html_x( 'Prices', 'type', 'forqy' ),
			'menu_sections'    => esc_html_x( 'Sections', 'type', 'forqy' ),
			'menu_ingredients' => esc_html_x( 'Ingredients', 'type', 'forqy' ),
			'menu_badges'      => esc_html_x( 'Badges', 'type', 'forqy' ),
			'author'           => esc_html_x( 'Author', 'type', 'forqy' ),
			'date'             => esc_html_x( 'Date', 'type', 'forqy' ),
		);

	}

	add_filter( 'manage_edit-menu_columns', 'forqy_type_menu_columns' );

}

/*
----------------------------------------------------------------------------------------------------
Post Type Columns Content
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_menu_columns_content' ) ) {

	function forqy_type_menu_columns_content( $column ) {
		global $post;

		switch ( $column ) {

			// Thumbnail
			case 'thumbnail':

				$thumbnail = get_the_post_thumbnail( get_the_ID(), array( 60, 60 ) );

				if ( has_post_thumbnail() ) {
					echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail">' . $thumbnail . '</a>';
				} else {
					echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail empty"></a>';
				}

				break;

			// Prices
			case 'menu_prices':

				$prices = forqy_meta( 'fy_menu_price' );

				if ( ! empty( $prices ) ) {
					echo implode( ', ', $prices );
				}

				break;

			// Sections
			case 'menu_sections':

				$sections = get_the_terms( $post->ID, 'section' );

				if ( ! empty( $sections ) ) {

					foreach ( $sections as $section ) {
						if ( isset( $section->name ) ) {
							echo '<a href="' . get_edit_term_link( $section ) . '">' . esc_html( $section->name ) . '</a>';
						}
						if ( next( $sections ) ) {
							echo ', ';
						}
					}
				}

				break;

			// Ingredients
			case 'menu_ingredients':

				$ingredients = get_the_term_list( $post->ID, 'ingredient', '', ', ', '' );

				if ( ! empty( $ingredients ) ) {
					echo strip_tags( $ingredients );
				}

				break;

			// Badges
			case 'menu_badges':

				$badges = forqy_meta( 'fy_menu_badges' );

				if ( ! empty( $badges ) ) {

					foreach ( $badges as $badge ) {
						echo '<span class="listing-badge">' . esc_html( $badge ) . '</span>';

						if ( next( $badges ) ) {
							echo '<br>';
						}
					}
				}

				break;

		}

	}

	add_action( 'manage_menu_posts_custom_column', 'forqy_type_menu_columns_content', 10, 1 );

}

/*
----------------------------------------------------------------------------------------------------
Type Columns Orderby
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_menu_columns_orderby' ) ) {

	function forqy_type_menu_columns_orderby( $query ) {

		if ( is_admin() ) {

			if ( isset( $query->query['post_type'] ) ) {

				// Get the post type from the query
				$type    = $query->query['post_type'];
				$orderby = $query->get( 'orderby' );

				if ( ! empty( $type ) ) {

					// Default
					if ( $type == 'menu' && ! isset( $_GET['order'] ) ) {
						$query->set( 'orderby', array(
							'menu_order' => 'ASC',
							'date'       => 'ASC',
						) );
					}

					// Sort by Price
					if ( $type == 'menu' && $orderby == 'menu_prices' ) {
						$query->set( 'meta_key', 'fy_menu_price' );
						$query->set( 'orderby', 'meta_value' );
					}

				}

			}

		}

	}

	add_action( 'pre_get_posts', 'forqy_type_menu_columns_orderby' );

}

/*
----------------------------------------------------------------------------------------------------
Type Columns Sorting
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_menu_columns_sorting' ) ) {

	function forqy_type_menu_columns_sorting(): array {

		return array(
			'title'         => 'title',
			'menu_sections' => 'menu_sections',
			'menu_prices'   => 'menu_prices',
			'author'        => 'author',
			'date'          => 'date',
		);

	}

	add_filter( 'manage_edit-menu_sortable_columns', 'forqy_type_menu_columns_sorting' );

}
