<?php

/*

Gallery Type

*/

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;

/*
====================================================================================================
Register Type
====================================================================================================
*/

if ( ! function_exists( 'forqy_type_gallery_register' ) ) {

	function forqy_type_gallery_register() {

		register_post_type( 'gallery', array(
			'labels'              => array(
				'name'                     => esc_html_x( 'Gallery', 'type', 'forqy' ),
				'menu_name'                => esc_html_x( 'Gallery', 'type', 'forqy' ),
				'singular_name'            => esc_html_x( 'Gallery', 'type', 'forqy' ),
				'name_admin_bar'           => esc_html_x( 'Gallery', 'type', 'forqy' ),
				'all_items'                => esc_html_x( 'All Galleries', 'type', 'forqy' ),
				'add_new'                  => esc_html_x( 'Add New Gallery', 'type', 'forqy' ),
				'add_new_item'             => esc_html_x( 'Add New Gallery', 'type', 'forqy' ),
				'edit_item'                => esc_html_x( 'Edit Gallery', 'type', 'forqy' ),
				'new_item'                 => esc_html_x( 'New Gallery', 'type', 'forqy' ),
				'view_item'                => esc_html_x( 'View Gallery', 'type', 'forqy' ),
				'view_items'               => esc_html_x( 'View Galleries', 'type', 'forqy' ),
				'search_items'             => esc_html_x( 'Search Galleries', 'type', 'forqy' ),
				'not_found'                => esc_html_x( 'No Galleries', 'type', 'forqy' ),
				'not_found_in_trash'       => esc_html_x( 'No Galleries Found in Trash', 'type', 'forqy' ),
				'archives'                 => esc_html_x( 'Gallery Archives', 'type', 'forqy' ),
				'attributes'               => esc_html_x( 'Gallery Attributes', 'type', 'forqy' ),
				'item_published'           => esc_html_x( 'Gallery published.', 'type', 'forqy' ),
				'item_published_privately' => esc_html_x( 'Gallery published privately.', 'type', 'forqy' ),
				'item_scheduled'           => esc_html_x( 'Gallery scheduled.', 'type', 'forqy' ),
				'item_updated'             => esc_html_x( 'Gallery updated.', 'type', 'forqy' ),
			),
			'public'              => true,
			'show_ui'             => true,
			'show_in_nav_menus'   => true,
			'show_in_admin_bar'   => true,
			'show_in_rest'        => true,
			'capability_type'     => 'post',
			'hierarchical'        => true,
			'has_archive'         => false,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'query_var'           => true,
			'rewrite'             => array(
				'slug'       => get_theme_mod( 'fy_slug_gallery', 'gallery' ),
				'with_front' => false,
			),
			'menu_position'       => 35,
			'menu_icon'           => 'data:image/svg+xml;base64,' . base64_encode( '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path fill="rgba(240,246,252,.6)" d="M16,4V3h-4v1H6V3H4v1H2v13h16V4H16z M16,15h-6H4v-4h2c0,2.2,1.8,4,4,4s4-1.8,4-4h2V15z M8,11c0-1.1,0.9-2,2-2 s2,0.9,2,2s-0.9,2-2,2S8,12.1,8,11z M16,9h-2.6c-0.7-1.2-2-2-3.4-2S7.2,7.8,6.6,9H4V6h12V9z"/></svg>' ),
			'supports'            => array(
				'title',
				'editor',
				'author',
				'excerpt',
				'thumbnail',
				'comments',
				'revisions',
				'page-attributes',
			),
		) );

	}

	add_action( 'init', 'forqy_type_gallery_register' );

}

/*
====================================================================================================
Admin Listing Columns
====================================================================================================
*/

/*
----------------------------------------------------------------------------------------------------
Type Columns Edit
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_gallery_columns' ) ) {

	function forqy_type_gallery_columns(): array {

		return array(
			'cb'                 => "<input type=\"checkbox\">",
			'thumbnail'          => '',
			'title'              => esc_html_x( 'Title', 'type', 'forqy' ),
			'gallery_categories' => esc_html_x( 'Categories', 'type', 'forqy' ),
			'author'             => esc_html_x( 'Author', 'type', 'forqy' ),
			'date'               => esc_html_x( 'Date', 'type', 'forqy' ),
		);

	}

	add_filter( 'manage_edit-gallery_columns', 'forqy_type_gallery_columns' );

}

/*
----------------------------------------------------------------------------------------------------
Post Type Columns Content
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_gallery_columns_content' ) ) {

	function forqy_type_gallery_columns_content( $column ) {
		global $post;

		switch ( $column ) {

			// Thumbnail
			case 'thumbnail':

				$video     = forqy_meta( 'fy_video' );
				$thumbnail = get_the_post_thumbnail( get_the_ID(), array( 60, 60 ) );

				if ( has_post_thumbnail() ) {
					if ( ! empty( $video ) ) {
						echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail video">' . $thumbnail . '</a>';
					} else {
						echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail">' . $thumbnail . '</a>';
					}
				} else if ( ! empty( $video ) ) {
					echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail empty video"></a>';
				} else {
					echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail empty"></a>';
				}

				break;

			// Categories
			case 'gallery_categories':

				$categories = get_the_terms( $post->ID, 'category-gallery' );

				if ( ! empty( $categories ) ) {

					foreach ( $categories as $category ) {
						echo '<a href="' . get_edit_term_link( $category ) . '">';
						echo esc_html( $category->name );
						echo '</a>';
						if ( next( $categories ) ) {
							echo ', ';
						}
					}
				}

				break;

		}

	}

	add_action( 'manage_gallery_posts_custom_column', 'forqy_type_gallery_columns_content', 10, 1 );

}

/*
----------------------------------------------------------------------------------------------------
Type Columns Sorting
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_gallery_columns_sorting' ) ) {

	function forqy_type_gallery_columns_sorting(): array {

		return array(
			'title'  => 'title',
			'author' => 'author',
			'date'   => 'date',
		);

	}

	add_filter( 'manage_edit-gallery_sortable_columns', 'forqy_type_gallery_columns_sorting' );

}

/*
----------------------------------------------------------------------------------------------------
Type Columns Default Sort
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_gallery_columns_sorting_default' ) ) {

	function forqy_type_gallery_columns_sorting_default( $query ) {

		if ( is_admin() ) {

			if ( isset( $query->query['post_type'] ) ) {

				// Get the post type from the query
				$type = $query->query['post_type'];

				if ( ! empty( $type ) ) {

					if ( $type == 'gallery' && ! isset( $_GET['order'] ) ) {
						$query->set( 'orderby', array(
							'menu_order' => 'ASC',
							'date'       => 'DESC',
						) );
					}

				}

			}

		}

	}

	add_filter( 'pre_get_posts', 'forqy_type_gallery_columns_sorting_default' );

}
