<?php

/*

Event Type

*/

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;

/*
====================================================================================================
Register Type
====================================================================================================
*/

if ( ! function_exists( 'forqy_type_event_register' ) ) {

	function forqy_type_event_register() {

		register_post_type( 'event', array(
			'labels'              => array(
				'name'                     => esc_html_x( 'Events', 'type', 'forqy' ),
				'menu_name'                => esc_html_x( 'Events', 'type', 'forqy' ),
				'singular_name'            => esc_html_x( 'Event', 'type', 'forqy' ),
				'name_admin_bar'           => esc_html_x( 'Event', 'type', 'forqy' ),
				'all_items'                => esc_html_x( 'All Events', 'type', 'forqy' ),
				'add_new'                  => esc_html_x( 'Add New Event', 'type', 'forqy' ),
				'add_new_item'             => esc_html_x( 'Add New Event', 'type', 'forqy' ),
				'edit_item'                => esc_html_x( 'Edit Event', 'type', 'forqy' ),
				'new_item'                 => esc_html_x( 'New Event', 'type', 'forqy' ),
				'view_item'                => esc_html_x( 'View Event', 'type', 'forqy' ),
				'view_items'               => esc_html_x( 'View Events', 'type', 'forqy' ),
				'search_items'             => esc_html_x( 'Search Events', 'type', 'forqy' ),
				'not_found'                => esc_html_x( 'No Events', 'type', 'forqy' ),
				'not_found_in_trash'       => esc_html_x( 'No Events Found in Trash', 'type', 'forqy' ),
				'archives'                 => esc_html_x( 'Event Archives', 'type', 'forqy' ),
				'attributes'               => esc_html_x( 'Event Attributes', 'type', 'forqy' ),
				'item_published'           => esc_html_x( 'Event published.', 'type', 'forqy' ),
				'item_published_privately' => esc_html_x( 'Event published privately.', 'type', 'forqy' ),
				'item_scheduled'           => esc_html_x( 'Event scheduled.', 'type', 'forqy' ),
				'item_updated'             => esc_html_x( 'Event updated.', 'type', 'forqy' ),
			),
			'public'              => true,
			'show_ui'             => true,
			'show_in_nav_menus'   => true,
			'show_in_admin_bar'   => true,
			'show_in_rest'        => true,
			'capability_type'     => 'post',
			'hierarchical'        => true,
			'has_archive'         => false,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'query_var'           => true,
			'rewrite'             => array(
				'slug'       => get_theme_mod( 'fy_slug_event', 'event' ),
				'with_front' => false,
			),
			'menu_position'       => 34,
			'menu_icon'           => 'data:image/svg+xml;base64,' . base64_encode( '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path fill="rgba(240,246,252,.6)" d="M9,8H5v3h4V8z M16,4V2h-2v2H6V2H4v2H2v13h16V4H16z M16,15H4V7h12V15z"/></svg>' ),
			'supports'            => array(
				'title',
				'editor',
				'author',
				'excerpt',
				'thumbnail',
				'comments',
				'revisions',
			),
		) );

	}

	add_action( 'init', 'forqy_type_event_register' );

}

/*
====================================================================================================
Admin Listing Columns
====================================================================================================
*/

/*
----------------------------------------------------------------------------------------------------
Type Columns Edit
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_event_columns' ) ) {

	function forqy_type_event_columns(): array {

		return array(
			'cb'             => "<input type=\"checkbox\">",
			'thumbnail'      => '',
			'title'          => esc_html_x( 'Title', 'type', 'forqy' ),
			'event_date'     => esc_html_x( 'Start Date', 'type', 'forqy' ),
			'event_date_end' => esc_html_x( 'End Date', 'type', 'forqy' ),
			'event_location' => esc_html_x( 'Location', 'type', 'forqy' ),
			'author'         => esc_html_x( 'Author', 'type', 'forqy' ),
			'date'           => esc_html_x( 'Date', 'type', 'forqy' ),
		);

	}

	add_filter( 'manage_edit-event_columns', 'forqy_type_event_columns' );

}

/*
----------------------------------------------------------------------------------------------------
Type Columns Content
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_event_columns_content' ) ) {

	function forqy_type_event_columns_content( $column ) {

		switch ( $column ) {

			// Thumbnail
			case 'thumbnail':

				$video     = forqy_meta( 'fy_video' );
				$thumbnail = get_the_post_thumbnail( get_the_ID(), array( 60, 60 ) );

				if ( has_post_thumbnail() ) {
					if ( ! empty( $video ) ) {
						echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail video">' . $thumbnail . '</a>';
					} else {
						echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail">' . $thumbnail . '</a>';
					}
				} else if ( ! empty( $video ) ) {
					echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail empty video"></a>';
				} else {
					echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail empty"></a>';
				}

				break;

			// Start Date
			case 'event_date':

				$current_date   = date( 'Y/m/d', current_time( 'timestamp' ) );
				$event_date     = forqy_meta( 'fy_event_date' );
				$event_date_end = forqy_meta( 'fy_event_date_end' );

				if ( ! empty( $event_date ) ) {
					if ( $event_date_end < $current_date ) {
						echo '<del title="' . _x( 'Past Event', 'type', 'forqy' ) . '">' . esc_html( $event_date ) . '</del>';
					} else {
						echo esc_html( $event_date );
					}
				}

				break;

			// End Date
			case 'event_date_end':

				$current_date   = date( 'Y/m/d', current_time( 'timestamp' ) );
				$event_date_end = forqy_meta( 'fy_event_date_end' );

				if ( ! empty( $event_date_end ) ) {
					if ( $event_date_end < $current_date ) {
						echo '<del title="' . _x( 'Past Event', 'type', 'forqy' ) . '">' . esc_html( $event_date_end ) . '</del>';
					} else {
						echo esc_html( $event_date_end );
					}
				}

				break;

			// Location
			case 'event_location':

				$event_location = forqy_meta( 'fy_event_location' );

				if ( ! empty( $event_location ) ) {
					echo esc_html( $event_location );
				}

				break;

		}

	}

	add_action( 'manage_event_posts_custom_column', 'forqy_type_event_columns_content', 10, 1 );

}

/*
----------------------------------------------------------------------------------------------------
Type Columns Orderby
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_event_columns_orderby' ) ) {

	function forqy_type_event_columns_orderby( $query ) {

		if ( is_admin() ) {

			if ( isset( $query->query['post_type'] ) ) {

				$type    = $query->query['post_type'];
				$orderby = $query->get( 'orderby' );

				if ( ! empty( $type ) ) {

					// Default
					if ( $type == 'event' && ! isset( $_GET['order'] ) ) {
						// Sort by start date by default if is not set
						$query->set( 'meta_key', 'fy_event_date' );
						$query->set( 'orderby', array(
							'meta_value' => 'ASC',
							'date'       => 'ASC',
						) );
					}
					// By Start Date
					if ( $type == 'event' && $orderby == 'event_date' ) {
						$query->set( 'meta_key', 'fy_event_date' );
						$query->set( 'orderby', 'meta_value' );
					}

				}

			}

		}

	}

	add_action( 'pre_get_posts', 'forqy_type_event_columns_orderby' );

}

/*
----------------------------------------------------------------------------------------------------
Type Columns Sorting
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_event_columns_sorting' ) ) {

	function forqy_type_event_columns_sorting(): array {

		return array(
			'title'      => 'title',
			'event_date' => 'event_date',
			'author'     => 'author',
			'date'       => 'date',
		);

	}

	add_filter( 'manage_edit-event_sortable_columns', 'forqy_type_event_columns_sorting' );

}
