<?php

/*

Album Type

*/

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;

/*
====================================================================================================
Register Type
====================================================================================================
*/

if ( ! function_exists( 'forqy_type_album_register' ) ) {

	function forqy_type_album_register() {

		register_post_type( 'album', array(
			'labels'              => array(
				'name'                     => esc_html_x( 'Albums', 'type', 'forqy' ),
				'menu_name'                => esc_html_x( 'Albums', 'type', 'forqy' ),
				'singular_name'            => esc_html_x( 'Album', 'type', 'forqy' ),
				'name_admin_bar'           => esc_html_x( 'Album', 'type', 'forqy' ),
				'all_items'                => esc_html_x( 'All Albums', 'type', 'forqy' ),
				'add_new'                  => esc_html_x( 'Add New Album', 'type', 'forqy' ),
				'add_new_item'             => esc_html_x( 'Add New Album', 'type', 'forqy' ),
				'edit_item'                => esc_html_x( 'Edit Album', 'type', 'forqy' ),
				'new_item'                 => esc_html_x( 'New Album', 'type', 'forqy' ),
				'view_item'                => esc_html_x( 'View Album', 'type', 'forqy' ),
				'view_items'               => esc_html_x( 'View Albums', 'type', 'forqy' ),
				'search_items'             => esc_html_x( 'Search Albums', 'type', 'forqy' ),
				'not_found'                => esc_html_x( 'No Albums', 'type', 'forqy' ),
				'not_found_in_trash'       => esc_html_x( 'No Albums Found in Trash', 'type', 'forqy' ),
				'archives'                 => esc_html_x( 'Album Archives', 'type', 'forqy' ),
				'attributes'               => esc_html_x( 'Album Attributes', 'type', 'forqy' ),
				'item_published'           => esc_html_x( 'Album published.', 'type', 'forqy' ),
				'item_published_privately' => esc_html_x( 'Album published privately.', 'type', 'forqy' ),
				'item_scheduled'           => esc_html_x( 'Album scheduled.', 'type', 'forqy' ),
				'item_updated'             => esc_html_x( 'Album updated.', 'type', 'forqy' ),
			),
			'public'              => true,
			'show_ui'             => true,
			'show_in_nav_menus'   => true,
			'show_in_admin_bar'   => true,
			'show_in_rest'        => true,
			'capability_type'     => 'post',
			'hierarchical'        => true,
			'has_archive'         => false,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'query_var'           => true,
			'rewrite'             => array(
				'slug'       => get_theme_mod( 'fy_slug_album', 'album' ),
				'with_front' => false,
			),
			'menu_position'       => 33,
			'menu_icon'           => 'data:image/svg+xml;base64,' . base64_encode( '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path fill="rgba(240,246,252,.6)" d="M6,5v7.2C5.7,12.1,5.4,12,5,12c-1.7,0-3,1.3-3,3s1.3,3,3,3s3-1.3,3-3v-4.7l6-1.7v2.5c-0.3-0.1-0.6-0.2-1-0.2 c-1.7,0-3,1.3-3,3s1.3,3,3,3c1.3,0,2.4-0.8,2.8-2H16V2L6,5z M5,16c-0.6,0-1-0.4-1-1s0.4-1,1-1s1,0.4,1,1S5.6,16,5,16z M13,15 c-0.6,0-1-0.4-1-1s0.4-1,1-1s1,0.4,1,1S13.6,15,13,15z M14,6.7L8,8.3v-2l6-1.7V6.7z"/></svg>' ),
			'supports'            => array(
				'title',
				'editor',
				'author',
				'excerpt',
				'thumbnail',
				'comments',
				'revisions',
				'page-attributes',
			),
		) );

	}

	add_action( 'init', 'forqy_type_album_register' );

}

/*
====================================================================================================
Admin Listing Columns
====================================================================================================
*/

/*
----------------------------------------------------------------------------------------------------
Type Columns Edit
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_album_columns' ) ) {

	function forqy_type_album_columns(): array {

		return array(
			'cb'           => "<input type=\"checkbox\">",
			'thumbnail'    => '',
			'title'        => esc_html_x( 'Title', 'type', 'forqy' ),
			'album_date'   => esc_html_x( 'Release Date', 'type', 'forqy' ),
			'album_number' => esc_html_x( 'Catalog #', 'type', 'forqy' ),
			'album_artist' => esc_html_x( 'Artist', 'type', 'forqy' ),
			'album_label'  => esc_html_x( 'Label', 'type', 'forqy' ),
			'album_price'  => esc_html_x( 'Price', 'type', 'forqy' ),
			'album_status' => esc_html_x( 'Status', 'type', 'forqy' ),
			'author'       => esc_html_x( 'Author', 'type', 'forqy' ),
			'date'         => esc_html_x( 'Date', 'type', 'forqy' ),
		);

	}

	add_filter( 'manage_edit-album_columns', 'forqy_type_album_columns' );

}

/*
----------------------------------------------------------------------------------------------------
Type Columns Content
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_album_columns_content' ) ) {

	function forqy_type_album_columns_content( $column ) {

		switch ( $column ) {

			// Thumbnail
			case 'thumbnail':

				$video     = forqy_meta( 'fy_video' );
				$thumbnail = get_the_post_thumbnail( get_the_ID(), array( 60, 60 ) );

				if ( has_post_thumbnail() ) {
					if ( ! empty( $video ) ) {
						echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail video">' . $thumbnail . '</a>';
					} else {
						echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail">' . $thumbnail . '</a>';
					}
				} else if ( ! empty( $video ) ) {
					echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail empty video"></a>';
				} else {
					echo '<a href="' . get_edit_post_link() . '" class="post-thumbnail empty"></a>';
				}

				break;

			// Release Date
			case 'album_date':

				$album_date = forqy_meta( 'fy_album_date' );

				if ( ! empty( $album_date ) ) {
					echo esc_html( $album_date );
				}

				break;

			// Catalog Number
			case 'album_number':

				$album_number = forqy_meta( 'fy_album_number' );

				if ( ! empty( $album_number ) ) {
					echo esc_html( $album_number );
				}

				break;

			// Artist
			case 'album_artist':

				$album_artist = forqy_meta( 'fy_album_artist' );

				if ( ! empty( $album_artist ) ) {
					echo esc_html( $album_artist );
				}

				break;

			// Label
			case 'album_label':

				$album_label = forqy_meta( 'fy_album_label' );

				if ( ! empty( $album_label ) ) {
					echo esc_html( $album_label );
				}

				break;

			// Price
			case 'album_price':

				$album_price = forqy_meta( 'fy_album_price' );

				if ( ! empty( $album_price ) ) {
					echo esc_html( $album_price );
				}

				break;

			// Status
			case 'album_status':

				$album_status = forqy_meta( 'fy_album_status' );

				if ( ! empty( $album_status ) ) {
					printf( '<span class="listing-badge">%s</span>', $album_status );
				}

				break;

		}

	}

	add_action( 'manage_album_posts_custom_column', 'forqy_type_album_columns_content', 10, 1 );

}

/*
----------------------------------------------------------------------------------------------------
Type Columns Orderby
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_album_columns_orderby' ) ) {

	function forqy_type_album_columns_orderby( $query ) {

		if ( is_admin() ) {

			if ( isset( $query->query['post_type'] ) ) {

				// Get the post type from the query
				$type = $query->query['post_type'];

				if ( ! empty( $type ) ) {

					if ( $type == 'album' && ! isset( $_GET['order'] ) ) {
						$query->set( 'orderby', array(
							'menu_order' => 'ASC',
							'date'       => 'DESC',
						) );
					}

				}

			}

		}

	}

	add_action( 'pre_get_posts', 'forqy_type_album_columns_orderby' );

}

/*
----------------------------------------------------------------------------------------------------
Type Columns Sorting
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_type_album_columns_sorting' ) ) {

	function forqy_type_album_columns_sorting(): array {

		return array(
			'album_date'   => 'album_date',
			'album_number' => 'album_number',
			'date'         => 'date',
		);

	}

	add_filter( 'manage_edit-album_sortable_columns', 'forqy_type_album_columns_sorting' );

}
