<?php

/*

Menu Taxonomy

*/

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'forqy_taxonomy_menu_section_register' ) ) {

	/**
	 * Register Section [category]
	 */
	function forqy_taxonomy_menu_section_register() {

		register_taxonomy( 'section', 'menu', array(
			'labels'       => array(
				'name'              => esc_html_x( 'Sections', 'type', 'forqy' ),
				'singular_name'     => esc_html_x( 'Section', 'type', 'forqy' ),
				'search_items'      => esc_html_x( 'Search Sections', 'type', 'forqy' ),
				'all_items'         => esc_html_x( 'All Sections', 'type', 'forqy' ),
				'parent_item'       => esc_html_x( 'Parent Section', 'type', 'forqy' ),
				'parent_item_colon' => esc_html_x( 'Parent Section:', 'type', 'forqy' ),
				'edit_item'         => esc_html_x( 'Edit Section', 'type', 'forqy' ),
				'view_item'         => esc_html_x( 'View Section', 'type', 'forqy' ),
				'update_item'       => esc_html_x( 'Update Section', 'type', 'forqy' ),
				'add_new_item'      => esc_html_x( 'Add New Section', 'type', 'forqy' ),
				'new_item_name'     => esc_html_x( 'New Menu Section', 'type', 'forqy' ),
				'not_found'         => esc_html_x( 'No sections found.', 'type', 'forqy' ),
				'back_to_items'     => esc_html_x( '← Back to sections', 'type', 'forqy' ),
			),
			'label'        => esc_html_x( 'Sections', 'type', 'forqy' ),
			'show_ui'      => true,
			'show_in_menu' => true,
			'show_in_rest' => true,
			'hierarchical' => true,
			'tax_position' => true, // support for the taxonomy sorting with plugin "Simple Taxonomy Ordering"
			'has_archive'  => true,
			'rewrite'      => array(
				'slug'       => get_theme_mod( 'fy_slug_menu_section', 'menu' ),
				'with_front' => false,
			),
		) );

	}

	add_action( 'init', 'forqy_taxonomy_menu_section_register' );

}


if ( ! function_exists( 'forqy_taxonomy_menu_ingredient_register' ) ) {

	/**
	 * Register Ingredient [tag]
	 */
	function forqy_taxonomy_menu_ingredient_register() {

		register_taxonomy( 'ingredient', 'menu', array(
			'labels'       => array(
				'name'                       => esc_html_x( 'Ingredients', 'type', 'forqy' ),
				'singular_name'              => esc_html_x( 'Ingredient', 'type', 'forqy' ),
				'search_items'               => esc_html_x( 'Search Ingredients', 'type', 'forqy' ),
				'popular_items'              => esc_html_x( 'Popular Ingredients', 'type', 'forqy' ),
				'all_items'                  => esc_html_x( 'All Ingredients', 'type', 'forqy' ),
				'edit_item'                  => esc_html_x( 'Edit Ingredient', 'type', 'forqy' ),
				'update_item'                => esc_html_x( 'Update Ingredient', 'type', 'forqy' ),
				'add_new_item'               => esc_html_x( 'Add New Ingredient', 'type', 'forqy' ),
				'new_item_name'              => esc_html_x( 'New Ingredient Name', 'type', 'forqy' ),
				'separate_items_with_commas' => esc_html_x( 'Separate ingredients with commas', 'type', 'forqy' ),
				'add_or_remove_items'        => esc_html_x( 'Add or remove ingredients', 'type', 'forqy' ),
				'choose_from_most_used'      => esc_html_x( 'Choose from the most used ingredients', 'type', 'forqy' ),
				'not_found'                  => esc_html_x( 'No ingredients found.', 'type', 'forqy' ),
				'back_to_items'              => esc_html_x( '← Back to ingredients', 'type', 'forqy' ),
			),
			'label'        => esc_html_x( 'Ingredients', 'type', 'forqy' ),
			'show_ui'      => true,
			'show_in_menu' => true,
			'show_in_rest' => true,
			'hierarchical' => false,
			'has_archive'  => true,
			'rewrite'      => array(
				'slug'       => get_theme_mod( 'fy_slug_menu_ingredient', 'ingredient' ),
				'with_front' => false
			),
		) );

	}

	add_action( 'init', 'forqy_taxonomy_menu_ingredient_register' );

}

if ( ! function_exists( 'forqy_taxonomy_filter_by_section' ) ) {

	/**
	 * Filter by Section
	 */
	function forqy_taxonomy_filter_by_section() {
		global $typenow;

		$type     = 'menu';
		$taxonomy = 'section';

		if ( $typenow === $type && is_object_in_taxonomy( $type, $taxonomy ) ) {

			echo '<label class="screen-reader-text" for="' . $taxonomy . '">' . get_taxonomy( $taxonomy )->labels->filter_by_item . '</label>';

			wp_dropdown_categories( array(
				'taxonomy'        => $taxonomy,
				'name'            => $taxonomy,
				'value_field'     => 'slug',
				'show_option_all' => get_taxonomy( $taxonomy )->labels->all_items,
				'selected'        => get_query_var( $taxonomy ) ? get_query_var( $taxonomy ) : 0,
				'orderby'         => 'name',
				'hide_empty'      => 0,
				'hierarchical'    => 1,
				'show_count'      => 1,
			) );

		}

	}

	add_action( 'restrict_manage_posts', 'forqy_taxonomy_filter_by_section' );

}
