/*jslint browser */
/*global window, jQuery, wp */

/**
 * Taximage
 * @version 1.0.1
 * @requires jQuery
 */

(function ($) {
    "use strict";

    let taxImageUploader;

    const taxImageButtonAdd = $(".js-tax-image-add");
    const taxImagePreview = $(".js-tax-image-preview");
    const taxImage = $(".js-tax-image");
    const taxImageButtonRemove = $(".js-tax-image-remove");

    taxImageButtonAdd.on("click", function (e) {
        e.preventDefault();

        if (taxImageUploader) {
            taxImageUploader.open();
            return;
        }

        taxImageUploader = wp.media.frames.file_frame = wp.media({
            title: translation.add_image,
            button: {
                text: translation.use_image
            },
            class: $(this).attr('id')
        });

        taxImageUploader.on("select", function () {
            const attachment = taxImageUploader.state().get("selection").first().toJSON();

            taxImagePreview.attr("src", attachment.url).css("display", "block");
            taxImage.attr("value", attachment.id);
            taxImageButtonAdd.html(translation.change_image);
            taxImageButtonRemove.css("display", "inline-block");
        });

        taxImageUploader.open();

    });

    taxImageButtonRemove.on("click", function (e) {
        e.preventDefault();

        $(this).css("display", "none");
        taxImagePreview.css("display", "none");
        taxImage.attr("value", "");
        taxImageButtonAdd.html(translation.add_image);
    });

}(jQuery));