<?php

/**
 * Taxonomy Image
 */

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;

if ( !class_exists( 'forqy_Taxonomy_Image' ) ) {

	/**
	 * Taxonomy Image
	 */
	class forqy_Taxonomy_Image {

		function __construct() {
			add_action( 'admin_head', array( $this, 'init' ) );
			add_action( 'edit_term', array( $this, 'save_fields' ), 10, 3 );
			add_action( 'create_term', array( $this, 'save_fields' ), 10, 3 );
		}

		function init() {

			$taxonomies = apply_filters( 'forqy_types_taximage_taxonomies', array(
				'category',
				'category-event',
				'category-gallery',
				'category-album',
				'category-portfolio',
				'section',
			) );

			if ( is_array( $taxonomies ) ) {

				foreach ( $taxonomies as $taxonomy ) {
					if ( current_theme_supports( 'forqy-taximage' ) ) {
						add_action( $taxonomy . '_add_form_fields', array( $this, 'add_fields' ) );
						add_action( $taxonomy . '_edit_form_fields', array( $this, 'edit_fields' ) );
						add_filter( "manage_edit-{$taxonomy}_columns", array( $this, 'add_taxonomy_column' ) );
						add_filter( "manage_{$taxonomy}_custom_column", array( $this, 'edit_taxonomy_columns' ), 10, 3 );
					}
				}
			}
		}

		// Fields on Add Screen
		function add_fields() {

			$this->setup_field_scripts(); ?>

            <div class="fy-tax-image-screen-add form-field">
                <input type="hidden" name="fy_tax_image" id="fy_tax_image" class="fy-tax-image js-tax-image" value="">
                <input type="hidden" name="fy_tax_image_classes" id="fy_tax_image_classes" value="">

                <div class="fy-tax-image-uploader">
                    <label>
						<?php echo esc_html_x( 'Image', 'type', 'forqy' ); ?>
                    </label>

                    <div class="fy-tax-image-container">

                        <img src="" alt="" class="fy-tax-image-preview js-tax-image-preview">

                        <div class="fy-tax-image-toolbar">

                            <button class="fy-tax-image-add js-tax-image-add button">
								<?php echo esc_html_x( 'Add Image', 'type', 'forqy' ); ?>
                            </button>

                            <button class="fy-tax-image-remove js-tax-image-remove button">
								<?php echo esc_html_x( 'Remove Image', 'type', 'forqy' ); ?>
                            </button>

                        </div>
                    </div>
                </div>
            </div>

			<?php
		}

		// Fields on Edit Screen
		function edit_fields( $taxonomy ) {

			$this->setup_field_scripts(); ?>

            <tr class="fy-tax-image-screen-edit form-field">
                <th>
                    <label for="fy_tax_image">
						<?php echo esc_html_x( 'Image', 'type', 'forqy' ); ?>
                    </label>
                </th>
                <td>
					<?php
					// Get Image
					$image = forqy_taxonomy_get_image_src( $taxonomy, 'large' );
					?>
                    <input type="hidden" name="fy_tax_image" id="fy_tax_image" class="fy-tax-image js-tax-image"
                           value="<?php echo ( isset( $image[ 'src' ] ) ) ? esc_url( $image[ 'src' ] ) : ''; ?>">
                    <input type="hidden" name="fy_tax_image_classes" id="fy_tax_image_classes" value="">

                    <div class="fy-tax-image-container">

                        <img src="<?php echo ( isset( $image[ 'src' ] ) ) ? esc_url( $image[ 'src' ] ) : ''; ?>" alt=""
                             class="fy-tax-image-preview js-tax-image-preview"
                             style="display:<?php echo ( isset( $image[ 'src' ] ) ) ? 'block' : 'none'; ?>;"
                             loading="lazy">

                        <div class="fy-tax-image-toolbar">

                            <button class="fy-tax-image-add js-tax-image-add button">
								<?php if ( isset( $image[ 'src' ] ) ) {
									echo esc_html_x( 'Change Image', 'type', 'forqy' );
								} else {
									echo esc_html_x( 'Add Image', 'type', 'forqy' );
								} ?>
                            </button>

                            <button class="fy-tax-image-remove js-tax-image-remove button"
                                    style="display:<?php echo ( isset( $image[ 'src' ] ) ) ? 'inline-block' : 'none'; ?>;">
								<?php echo esc_html_x( 'Remove Image', 'type', 'forqy' ); ?>
                            </button>

                        </div>

                    </div>
                </td>
            </tr>

			<?php
		}

		// Scripts
		function setup_field_scripts() {

			$script_url = apply_filters( 'forqy_types_taximage_script_url', plugins_url( '/js/taximage.js', __FILE__ ) );

			// Enqueue Media
			if ( !did_action( 'wp_enqueue_media' ) ) {
				wp_enqueue_media();
			}

			// Register
			wp_register_script( 'forqy-taxonomy-image', esc_url( $script_url ), array(
				'jquery'
			) );

			// Localize
			wp_localize_script( 'forqy-taxonomy-image', 'translation', array(
				'add_image'    => esc_html_x( 'Add Image', 'type', 'forqy' ),
				'change_image' => esc_html_x( 'Change Image', 'type', 'forqy' ),
				'use_image'    => esc_html_x( 'Use Image', 'type', 'forqy' ),
			) );

			// Enqueue
			wp_enqueue_script( 'forqy-taxonomy-image' );

		}

		// Save Taxonomy Image
		function save_fields( $term_id, $tt_id = null, $taxonomy = null ) {

			$option = "fy_tax_image_{$taxonomy}_{$term_id}";

			if ( isset( $_POST[ 'fy_tax_image' ] ) && ( $src = $_POST[ 'fy_tax_image' ] ) ) {

				if ( $src != '' ) {

					if ( isset( $_POST[ 'fy_tax_image_classes' ] ) && preg_match( '/wp-image-([0-9]{1,99})/', $_POST[ 'fy_tax_image_classes' ], $matches ) ) {
						update_option( $option, $matches[ 1 ] );
					} else {
						global $wpdb;

						$attachment = $wpdb->get_col( $wpdb->prepare( "SELECT ID FROM {$wpdb->posts} WHERE guid='%s';", $src ) );

						if ( isset( $attachment[ 0 ] ) && 0 < absint( $attachment[ 0 ] ) ) {
							update_option( $option, $attachment[ 0 ] );
						} else {
							update_option( $option, $src );
						}
					}

				} else {
					$test = get_option( $option );

					if ( $test ) {
						delete_option( $option );
					}
				}

			} else {
				$test = get_option( $option );

				if ( $test ) {
					delete_option( $option );
				}
			}

		}

		// Add Taxonomy Column
		function add_taxonomy_column( $columns ) {

			$columns[ 'thumbnail' ] = esc_html_x( 'Image', 'type', 'forqy' );

			return $columns;
		}

		// Edit Taxonomy Column
		function edit_taxonomy_columns( $out, $column_name, $term_id ) {

			if ( $column_name != 'thumbnail' ) {
				return $out;
			}

			$term  = get_term( $term_id, $_GET[ 'taxonomy' ] );
			$image = forqy_taxonomy_get_image( $term, array( 50, 50 ) );

			if ( $image ) {
				$out = '<div class="post-thumbnail">' . $image . '</a>';
			} else {
				$out = '<div class="post-thumbnail empty"></div>';
			}

			return $out;
		}

	}

	new forqy_Taxonomy_Image;

}
