<?php

/*

Album Taxonomy

*/

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'forqy_taxonomy_album_register' ) ) {

	/**
	 * Register Category [category]
	 */
	function forqy_taxonomy_album_register() {

		register_taxonomy( 'category-album', 'album', array(
			'labels'       => array(
				'name'              => esc_html_x( 'Categories', 'type', 'forqy' ),
				'singular_name'     => esc_html_x( 'Category', 'type', 'forqy' ),
				'search_items'      => esc_html_x( 'Search Categories', 'type', 'forqy' ),
				'all_items'         => esc_html_x( 'All Categories', 'type', 'forqy' ),
				'parent_item'       => esc_html_x( 'Parent Category', 'type', 'forqy' ),
				'parent_item_colon' => esc_html_x( 'Parent Category:', 'type', 'forqy' ),
				'edit_item'         => esc_html_x( 'Edit Category', 'type', 'forqy' ),
				'view_item'         => esc_html_x( 'View Category', 'type', 'forqy' ),
				'update_item'       => esc_html_x( 'Update Category', 'type', 'forqy' ),
				'add_new_item'      => esc_html_x( 'Add New Category', 'type', 'forqy' ),
				'new_item_name'     => esc_html_x( 'New Category Name', 'type', 'forqy' ),
				'not_found'         => esc_html_x( 'No categories found.', 'type', 'forqy' ),
				'back_to_items'     => esc_html_x( '← Back to categories', 'type', 'forqy' ),
			),
			'label'        => esc_html_x( 'Categories', 'forqy' ),
			'show_ui'      => true,
			'show_in_menu' => true,
			'show_in_rest' => true,
			'hierarchical' => true,
			'tax_position' => true, // support for the taxonomy sorting with plugin "Simple Taxonomy Ordering"
			'has_archive'  => true,
			'rewrite'      => array(
				'slug'       => get_theme_mod( 'fy_slug_album_category', 'albums' ),
				'with_front' => false,
			),
		) );

	}

	add_action( 'init', 'forqy_taxonomy_album_register' );

}
