<?php

/*

Video Metabox

*/

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;


if ( ! function_exists( 'forqy_metabox_video_register' ) ) {

	/**
	 * Register Metabox
	 *
	 * @param $meta_boxes
	 *
	 * @return mixed
	 */
	function forqy_metabox_video_register( $meta_boxes ) {

		if ( current_theme_supports( 'forqy-video' ) || current_theme_supports( 'forqy-metabox-video' ) ) {

			$meta_boxes[] = array(
				'id'         => 'forqy-metabox-video',
				'title'      => esc_html_x( 'Featured Video', 'type', 'forqy' ),
				'post_types' => array( 'post', 'page', 'slide', 'video', 'gallery', 'event', 'album', 'project' ),
				'context'    => 'side',
				'priority'   => 'low',
				'fields'     => array(
					array(
						'name'             => esc_html_x( 'Video File', 'type', 'forqy' ),
						'desc'             => esc_html_x( 'Upload a video in *.mp4 format. Please do not use large file sizes to keep faster loading.', 'type', 'forqy' ),
						'id'               => 'fy_video',
						'type'             => 'video',
						'max_file_uploads' => '1',
					),
					array(
						'type' => 'divider',
					),
					array(
						'name' => '',
						'desc' => esc_html_x( 'Autoplay?', 'type', 'forqy' ),
						'id'   => 'fy_video_autoplay',
						'type' => 'checkbox',
						'std'  => 1,
					),
					array(
						'name' => '',
						'desc' => esc_html_x( 'Loop?', 'type', 'forqy' ),
						'id'   => 'fy_video_loop',
						'type' => 'checkbox',
						'std'  => 1,
					),
					array(
						'name' => '',
						'desc' => esc_html_x( 'Muted?', 'type', 'forqy' ),
						'id'   => 'fy_video_muted',
						'type' => 'checkbox',
						'std'  => 1,
					),
				),
			);

		}

		return $meta_boxes;

	}

	add_filter( 'rwmb_meta_boxes', 'forqy_metabox_video_register' );

}
