<?php

/*

Slide Metabox

*/

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;


if ( ! function_exists( 'forqy_metabox_slide_register' ) ) {

	/**
	 * Register Metabox
	 *
	 * @param $meta_boxes
	 *
	 * @return mixed
	 */
	function forqy_metabox_slide_register( $meta_boxes ) {

		if ( current_theme_supports( 'forqy-slide' ) ) {

			// New Version with a Gutenberg Block Editor Support

			$meta_boxes[] = array(
				'id'         => 'forqy-metabox-slide',
				'title'      => esc_html_x( 'Slide', 'type', 'forqy' ),
				'post_types' => array( 'slide' ),
				'context'    => 'normal',
				'priority'   => 'high',
				'fields'     => array(
					array(
						'name' => esc_html_x( 'Title', 'type', 'forqy' ),
						'desc' => esc_html_x( 'Check if you want to display title.', 'type', 'forqy' ),
						'id'   => 'fy_slide_caption_title',
						'type' => 'checkbox',
						'std'  => '1',
					),
					array(
						'name'              => esc_html_x( 'Subtitle', 'type', 'forqy' ),
						'id'                => 'fy_slide_caption_subtitle',
						'type'              => 'text',
						'sanitize_callback' => 'wp_kses_post',
					),
					// Deprecated Content Field
					array(
						'name'              => esc_html_x( 'Content', 'type', 'forqy' ),
						'label_description' => ! empty( $_GET['post'] ) && ! empty( get_post_meta( $_GET['post'], 'fy_slide_caption_content', true ) ) ? esc_html_x( 'Deprecated! Use the block editor instead.', 'type', 'forqy' ) : '',
						'id'                => 'fy_slide_caption_content',
						'type'              => ! empty( $_GET['post'] ) && ! empty( get_post_meta( $_GET['post'], 'fy_slide_caption_content', true ) ) ? 'textarea' : 'hidden',
						'rows'              => 8,
					),
					array(
						'type' => 'divider',
					),
					array(
						'name' => esc_html_x( 'Button', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The button text. If you don\'t want to display the button, leave the field blank.', 'type', 'forqy' ),
						'id'   => 'fy_slide_caption_button',
						'type' => 'text',
					),
					array(
						'name' => '1. ' . esc_html_x( 'Button URL', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The URL you wish to link to like "/the-page" or "https://domain.com/the-page".', 'type', 'forqy' ),
						'id'   => 'fy_slide_caption_url',
						'type' => 'text',
					),
					array(
						'name' => '1. ' . esc_html_x( 'Open URL in a New Tab/Window?', 'type', 'forqy' ),
						'id'   => 'fy_slide_caption_url_target',
						'type' => current_theme_supports( 'forqy-slide-url-target' ) ? 'checkbox' : 'hidden',
					),
					array(
						'type' => 'divider',
					),
					array(
						'name' => '2. ' . esc_html_x( 'Button', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The button text. If you don\'t want to display the button, leave the field blank.', 'type', 'forqy' ),
						'id'   => 'fy_slide_caption_button_secondary',
						'type' => 'text',
					),
					array(
						'name' => '2. ' . esc_html_x( 'Button URL', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The URL you wish to link to like "/the-page" or "https://domain.com/the-page".', 'type', 'forqy' ),
						'id'   => 'fy_slide_caption_secondary_url',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'Open URL in a New Tab/Window?', 'type', 'forqy' ),
						'id'   => 'fy_slide_caption_secondary_url_target',
						'type' => current_theme_supports( 'forqy-slide-url-target' ) ? 'checkbox' : 'hidden',
					),
				),
			);

		} else {

			$meta_boxes[] = array(
				'id'         => 'forqy-metabox-slide',
				'title'      => esc_html_x( 'Slide', 'type', 'forqy' ),
				'post_types' => array( 'slide' ),
				'context'    => 'normal',
				'priority'   => 'high',
				'fields'     => array(
					array(
						'name' => esc_html_x( 'Title', 'type', 'forqy' ),
						'desc' => esc_html_x( 'Check if you want to display title.', 'type', 'forqy' ),
						'id'   => 'fy_slide_caption_title',
						'type' => 'checkbox',
						'std'  => '1',
					),
					array(
						'type' => 'divider',
					),
					array(
						'name' => esc_html_x( 'Content', 'type', 'forqy' ),
						'id'   => 'fy_slide_caption_content',
						'type' => 'textarea',
						'rows' => 8,
					),
					array(
						'type' => 'divider',
					),
					array(
						'name' => '1. ' . esc_html_x( 'Button', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The button text. If you don\'t want to display the button, leave the field blank.', 'type', 'forqy' ),
						'id'   => 'fy_slide_caption_button',
						'type' => 'text',
					),
					array(
						'name' => '1. ' . esc_html_x( 'Button URL', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The URL you wish to link to like "/the-page" or "https://domain.com/the-page".', 'type', 'forqy' ),
						'id'   => 'fy_slide_caption_url',
						'type' => 'text',
					),
					array(
						'type' => 'divider',
					),
					array(
						'name' => '2. ' . esc_html_x( 'Button', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The button text. If you don\'t want to display the button, leave the field blank.', 'type', 'forqy' ),
						'id'   => 'fy_slide_caption_button_secondary',
						'type' => 'text',
					),
					array(
						'name' => '2. ' . esc_html_x( 'Button URL', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The URL you wish to link to like "/the-page" or "https://domain.com/the-page".', 'type', 'forqy' ),
						'id'   => 'fy_slide_caption_secondary_url',
						'type' => 'text',
					),
				),
			);

		}

		return $meta_boxes;

	}

	add_filter( 'rwmb_meta_boxes', 'forqy_metabox_slide_register' );

}
