<?php

/*

Review Metabox

*/

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;


if ( ! function_exists( 'forqy_metabox_review_register' ) ) {

	/**
	 * Register Metabox
	 *
	 * @param $meta_boxes
	 *
	 * @return mixed
	 */
	function forqy_metabox_review_register( $meta_boxes ) {

		$meta_boxes[] = array(
			'id'         => 'forqy-metabox-review',
			'title'      => esc_html_x( 'Review', 'type', 'forqy' ),
			'post_types' => array( 'review' ),
			'context'    => 'normal',
			'priority'   => 'high',
			'fields'     => array(
				array(
					'name' => esc_html_x( 'Author', 'type', 'forqy' ),
					'id'   => 'fy_review_name',
					'type' => 'text',
				),
				array(
					'name' => esc_html_x( 'Position', 'type', 'forqy' ),
					'id'   => 'fy_review_position',
					'type' => 'text',
				),
				array(
					'type' => 'divider',
				),
				array(
					'name'    => esc_html_x( 'Rating', 'type', 'forqy' ),
					'id'      => 'fy_review_rating',
					'type'    => 'radio',
					'inline'  => true,
					'options' => array(
						'1' => esc_html_x( '*', 'type', 'forqy' ),
						'2' => esc_html_x( '**', 'type', 'forqy' ),
						'3' => esc_html_x( '***', 'type', 'forqy' ),
						'4' => esc_html_x( '****', 'type', 'forqy' ),
						'5' => esc_html_x( '*****', 'type', 'forqy' ),
					),
				),
			),
		);

		return $meta_boxes;

	}

	add_filter( 'rwmb_meta_boxes', 'forqy_metabox_review_register' );

}
