<?php

/*

Reservation Metabox

*/

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;


if ( ! function_exists( 'forqy_metabox_reservation_register' ) ) {

	/**
	 * Register Metabox
	 *
	 * @param $meta_boxes
	 *
	 * @return mixed
	 */
	function forqy_metabox_reservation_register( $meta_boxes ) {

		$current_date = date( 'm/d/Y' );
		$date_format  = get_theme_mod( 'fy_form_reservation_date_format', 'mm/dd/yy' );

		$meta_boxes[] = array(
			'id'         => 'forqy-metabox-reservation',
			'title'      => esc_html_x( 'Reservation Details', 'type', 'forqy' ),
			'post_types' => array( 'reservation' ),
			'context'    => 'normal',
			'priority'   => 'high',
			'fields'     => array(
				array(
					'name'    => esc_html_x( 'Status', 'type', 'forqy' ),
					'id'      => 'fy_reservation_status',
					'type'    => 'select',
					'options' => array(
						'pending'   => esc_html_x( 'Pending', 'type', 'forqy' ),
						'confirmed' => esc_html_x( 'Confirmed', 'type', 'forqy' ),
						'canceled'  => esc_html_x( 'Canceled', 'type', 'forqy' ),
						'closed'    => esc_html_x( 'Closed', 'type', 'forqy' ),
					),
				),
				array(
					'name'       => esc_html_x( 'Date', 'type', 'forqy' ),
					'id'         => 'fy_reservation_date',
					'type'       => 'date',
					'std'        => $current_date,
					'js_options' => array(
						'dateFormat'      => $date_format,
						'minDate'         => 0,
						'showButtonPanel' => false,
					),
				),
				array(
					'name' => esc_html_x( 'Time', 'type', 'forqy' ),
					'id'   => 'fy_reservation_time',
					'type' => 'time',
				),
				array(
					'name' => esc_html_x( 'Guests', 'type', 'forqy' ),
					'id'   => 'fy_reservation_persons',
					'type' => 'number',
				),
				array(
					'type' => 'divider',
				),
				array(
					'name' => esc_html_x( 'Name', 'type', 'forqy' ),
					'id'   => 'fy_reservation_name',
					'type' => 'text',
				),
				array(
					'name' => esc_html_x( 'Email', 'type', 'forqy' ),
					'id'   => 'fy_reservation_email',
					'type' => 'text',
				),
				array(
					'name' => esc_html_x( 'Phone', 'type', 'forqy' ),
					'id'   => 'fy_reservation_phone',
					'type' => 'text',
				),
				array(
					'name' => esc_html_x( 'Message', 'type', 'forqy' ),
					'id'   => 'fy_reservation_message',
					'type' => 'textarea',
					'rows' => 8,
				),
			),
		);

		return $meta_boxes;

	}

	add_filter( 'rwmb_meta_boxes', 'forqy_metabox_reservation_register' );

}
