<?php

/*

Project Metabox

*/

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;


if ( ! function_exists( 'forqy_metabox_project_register' ) ) {

	/**
	 * Register Metabox
	 *
	 * @param $meta_boxes
	 *
	 * @return mixed
	 */
	function forqy_metabox_project_register( $meta_boxes ) {

		if ( current_theme_supports( 'forqy-project' ) ) {

			// New version with a structured data support

			$meta_boxes[] = array(
				'id'         => 'forqy-metabox-project',
				'title'      => esc_html_x( 'Project', 'type', 'forqy' ),
				'post_types' => array( 'project' ),
				'context'    => 'normal',
				'priority'   => 'high',
				'fields'     => array(
					array(
						'name' => esc_html_x( 'Summary', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The short summary of the project.', 'type', 'forqy' ),
						'id'   => 'fy_project_summary',
						'type' => 'textarea',
					),
					array(
						'type' => 'heading',
						'name' => esc_html_x( 'Creator', 'type', 'forqy' ),
					),
					array(
						'name'    => esc_html_x( 'Creator', 'type', 'forqy' ),
						'id'      => 'fy_project_creator',
						'type'    => 'select',
						'options' => array(
							'Organization' => esc_html_x( 'Organization', 'type', 'forqy' ),
							'Person'       => esc_html_x( 'Person', 'type', 'forqy' ),
						),
					),
					array(
						'name' => esc_html_x( 'Name', 'type', 'forqy' ),
						'std'  => get_bloginfo( 'name' ),
						'id'   => 'fy_project_creator_name',
						'type' => 'text',
					),
					array(
						'type' => 'heading',
						'name' => esc_html_x( 'Client', 'type', 'forqy' ),
					),
					array(
						'name' => esc_html_x( 'Name', 'type', 'forqy' ),
						'id'   => 'fy_project_client',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'URL', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The client URL, e.g. "https://client.com/".', 'type', 'forqy' ),
						'id'   => 'fy_project_client_url',
						'type' => 'text',
					),
					array(
						'type' => 'heading',
						'name' => esc_html_x( 'Purchase', 'type', 'forqy' ),
					),
					array(
						'name' => esc_html_x( 'Price', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The price including currency symbol, e.g. "$25".', 'type', 'forqy' ),
						'id'   => 'fy_project_price',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'Button', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The button text. If you don\'t want to display the button, leave the field blank.', 'type', 'forqy' ),
						'id'   => 'fy_project_purchase',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'URL', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The URL you wish to link to like "/the-page" or "https://domain.com/the-page".', 'type', 'forqy' ),
						'id'   => 'fy_project_purchase_url',
						'type' => 'text',
					),
					array(
						'type' => 'heading',
						'name' => esc_html_x( 'Preview', 'type', 'forqy' ),
					),
					array(
						'name' => esc_html_x( 'Button', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The button text. If you don\'t want to display the button, leave the field blank.', 'type', 'forqy' ),
						'id'   => 'fy_project_preview',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'URL', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The URL you wish to link to like "/the-page" or "https://domain.com/the-page".', 'type', 'forqy' ),
						'id'   => 'fy_project_preview_url',
						'type' => 'text',
					),
				)
			);

		} else {

			$meta_boxes[] = array(
				'id'         => 'forqy-metabox-project',
				'title'      => esc_html_x( 'Project', 'type', 'forqy' ),
				'post_types' => array( 'project' ),
				'context'    => 'normal',
				'priority'   => 'high',
				'fields'     => array(
					array(
						'name' => esc_html_x( 'Summary', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The short summary of the project.', 'type', 'forqy' ),
						'id'   => 'fy_project_summary',
						'type' => 'textarea',
					),
					array(
						'type' => 'divider',
					),
					array(
						'name' => esc_html_x( 'Client', 'type', 'forqy' ),
						'id'   => 'fy_project_client',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'Client URL', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The client URL, e.g. "https://client.com/".', 'type', 'forqy' ),
						'id'   => 'fy_project_client_url',
						'type' => 'text',
					),
					array(
						'type' => 'divider',
					),
					array(
						'name' => esc_html_x( 'Preview Button', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The button text. If you don\'t want to display the button, leave the field blank.', 'type', 'forqy' ),
						'id'   => 'fy_project_preview',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'Preview URL', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The URL you wish to link to like "/the-page" or "https://domain.com/the-page".', 'type', 'forqy' ),
						'id'   => 'fy_project_preview_url',
						'type' => 'text',
					),
					array(
						'type' => 'divider',
					),
					array(
						'name' => esc_html_x( 'Purchase Price', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The price including currency symbol, e.g. "$25".', 'type', 'forqy' ),
						'id'   => 'fy_project_price',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'Purchase Button', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The button text. If you don\'t want to display the button, leave the field blank.', 'type', 'forqy' ),
						'id'   => 'fy_project_purchase',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'Purchase URL', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The URL you wish to link to like "/the-page" or "https://domain.com/the-page".', 'type', 'forqy' ),
						'id'   => 'fy_project_purchase_url',
						'type' => 'text',
					),
				),
			);

		}

		return $meta_boxes;

	}

	add_filter( 'rwmb_meta_boxes', 'forqy_metabox_project_register' );

}
