<?php

/*

Menu Metabox

*/

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;


if ( ! function_exists( 'forqy_metabox_menu_register' ) ) {

	/**
	 * Register Metabox
	 *
	 * @param $meta_boxes
	 *
	 * @return mixed
	 */
	function forqy_metabox_menu_register( $meta_boxes ) {

		$meta_boxes[] = array(
			'id'         => 'forqy-metabox-menu',
			'title'      => esc_html_x( 'Menu Item', 'type', 'forqy' ),
			'post_types' => array( 'menu' ),
			'context'    => 'normal',
			'priority'   => 'high',
			'fields'     => array(
				array(
					'name'       => esc_html_x( 'Prices', 'type', 'forqy' ),
					'desc'       => esc_html_x( 'Menu item price(s) including currency symbol, e.g. "$25", "$129 per Bottle", etc.', 'type', 'forqy' ),
					'id'         => 'fy_menu_price',
					'type'       => 'text',
					'clone'      => true,
					'sort_clone' => true,
				),
				array(
					'type' => 'divider',
				),
				array(
					'name'       => esc_html_x( 'Badges', 'type', 'forqy' ),
					'desc'       => esc_html_x( 'Menu item badge(s), e.g. "Specialty", "Spicy", "Recommended", etc.', 'type', 'forqy' ),
					'id'         => 'fy_menu_badges',
					'type'       => 'text',
					'clone'      => true,
					'sort_clone' => true,
				),
			),
		);

		return $meta_boxes;

	}

	add_filter( 'rwmb_meta_boxes', 'forqy_metabox_menu_register' );

}
