<?php

/*

Gallery Metabox

*/

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;


if ( ! function_exists( 'forqy_metabox_gallery_register' ) ) {

	/**
     * Register Metabox
     *
	 * @param $post_type
	 */
	function forqy_metabox_gallery_register( $post_type ) {
		$types = array( 'post', 'gallery', 'event', 'project', 'theme' );

		if ( in_array( $post_type, $types ) ) {
			add_meta_box( 'forqy-metabox-gallery', esc_html_x( 'Images', 'type', 'forqy' ), 'forqy_metabox_gallery_register_callback', $post_type, 'normal', 'high' );
		}
	}

	add_action( 'add_meta_boxes', 'forqy_metabox_gallery_register' );

}

if ( ! function_exists( 'forqy_metabox_gallery_register_callback' ) ) {

	/**
     * Callback
     *
	 * @param $post
	 */
	function forqy_metabox_gallery_register_callback( $post ) {
		wp_nonce_field( basename( __FILE__ ), 'gallery_meta_nonce' );
		$ids = get_post_meta( $post->ID, 'fy-gallery-images', true );
		?>

        <table class="form-table">
            <tr>
                <td>
                    <div class="fy-metabox-gallery-uploader">

                        <button class="fy-gallery-image-add js-gallery-image-add button button-primary"
                                data-uploader-title="<?php echo esc_attr_x( 'Add Images', 'type', 'forqy' ); ?>"
                                data-uploader-button-text="<?php echo esc_attr_x( 'Add Images', 'type', 'forqy' ); ?>">
							<?php echo esc_html_x( 'Add Images', 'type', 'forqy' ); ?>
                        </button>

                        <ul class="fy-gallery-images js-gallery-images">
							<?php if ( $ids ) {
								foreach ( $ids as $key => $value ) {

									$image = wp_get_attachment_image_src( $value, 'thumbnail' );
									?>

                                    <li>
                                        <input type="hidden" name="fy-gallery-images[<?php echo esc_attr( $key ); ?>]"
                                               value="<?php echo esc_attr( $value ); ?>">

                                        <div class="fy-gallery-image">
                                            <img class="image-preview" src="<?php echo esc_url( $image[0] ); ?>" alt="" loading="lazy">

                                            <button class="fy-gallery-image-remove js-gallery-image-remove button" title="<?php echo esc_attr_x( 'Remove', 'type', 'forqy' ); ?>">
                                                <svg class="icon" width="24" height="24" viewBox="0 0 24 24" aria-label="<?php echo esc_attr_x( 'Remove', 'type', 'forqy' ); ?>">
                                                    <polygon points="19,6.4 17.6,5 12,10.6 6.4,5 5,6.4 10.6,12 5,17.6 6.4,19 12,13.4 17.6,19 19,17.6 13.4,12"></polygon>
                                                </svg>
                                            </button>
                                        </div>
                                    </li>

								<?php }
							} ?>
                        </ul>

                    </div>
                </td>
            </tr>
        </table>

		<?php
	}
}

if ( ! function_exists( 'forqy_metabox_gallery_save' ) ) {

	/**
     * Save Metabox
     *
	 * @param $post_id
	 */
	function forqy_metabox_gallery_save( $post_id ) {

		if ( ! isset( $_POST['gallery_meta_nonce'] ) || ! wp_verify_nonce( $_POST['gallery_meta_nonce'], basename( __FILE__ ) ) ) {
			return;
		}
		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return;
		}
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		if ( isset( $_POST['fy-gallery-images'] ) ) {
			update_post_meta( $post_id, 'fy-gallery-images', $_POST['fy-gallery-images'] );
		} else {
			delete_post_meta( $post_id, 'fy-gallery-images' );
		}

	}

	add_action( 'save_post', 'forqy_metabox_gallery_save' );

}
