<?php

/*

Event Metabox

*/

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;


if ( ! function_exists( 'forqy_metabox_event_register' ) ) {

	/**
	 * Register Metabox
	 *
	 * @param $meta_boxes
	 *
	 * @return mixed
	 */
	function forqy_metabox_event_register( $meta_boxes ) {

		$current_date = date( 'Y/m/d' );
		$date_format  = 'yy/mm/dd';
		$currency     = 'USD';

		if ( current_theme_supports( 'forqy-event' ) ) {

			// New version with a structured data support

			$meta_boxes[] = array(
				'id'         => 'forqy-metabox-event',
				'title'      => esc_html_x( 'Event', 'type', 'forqy' ),
				'post_types' => array( 'event' ),
				'context'    => 'normal',
				'priority'   => 'high',
				'fields'     => array(
					array(
						'name'       => esc_html_x( 'Start Date', 'type', 'forqy' ),
						'desc'       => esc_html_x( 'The start date.', 'type', 'forqy' ),
						'id'         => 'fy_event_date',
						'type'       => 'date',
						'std'        => $current_date,
						'js_options' => array(
							'dateFormat'      => $date_format,
							'showButtonPanel' => false,
						),
					),
					array(
						'name'       => esc_html_x( 'End Date', 'type', 'forqy' ),
						'desc'       => esc_html_x( 'The end date. If the start date and end date are the same, the end date will remain hidden.', 'type', 'forqy' ),
						'id'         => 'fy_event_date_end',
						'type'       => 'date',
						'std'        => $current_date,
						'js_options' => array(
							'dateFormat'      => $date_format,
							'showButtonPanel' => false,
						),
					),
					array(
						'name' => esc_html_x( 'Time', 'type', 'forqy' ),
						'id'   => 'fy_event_time',
						'type' => 'text',
					),
					array(
						'type' => 'divider',
					),
					array(
						'name'    => esc_html_x( 'Status', 'type', 'forqy' ),
						'desc'    => esc_html_x( 'The status of the event.', 'type', 'forqy' ),
						'id'      => 'fy_event_status',
						'type'    => 'select',
						'options' => array(
							'EventScheduled'   => esc_html_x( 'Scheduled', 'type', 'forqy' ),
							'EventCancelled'   => esc_html_x( 'Cancelled', 'type', 'forqy' ),
							'EventMovedOnline' => esc_html_x( 'Moved Online', 'type', 'forqy' ),
							'EventPostponed'   => esc_html_x( 'Postponed', 'type', 'forqy' ),
						),
					),
					array(
						'name'    => esc_html_x( 'Attendance Mode', 'type', 'forqy' ),
						'desc'    => esc_html_x( 'Indicates whether the event occurs online, offline at a physical location, or a mix of both online and offline.', 'type', 'forqy' ),
						'id'      => 'fy_event_attendance_mode',
						'type'    => 'select',
						'options' => array(
							'OfflineEventAttendanceMode' => esc_html_x( 'Offline', 'type', 'forqy' ),
							'OnlineEventAttendanceMode'  => esc_html_x( 'Online', 'type', 'forqy' ),
							'MixedEventAttendanceMode'   => esc_html_x( 'Mixed', 'type', 'forqy' ),
						),
					),
					array(
						'type' => 'heading',
						'name' => esc_html_x( 'Location', 'type', 'forqy' ),
					),
					array(
						'name'    => esc_html_x( 'Location', 'type', 'forqy' ),
						'desc'    => esc_html_x( 'The location of the event.', 'type', 'forqy' ),
						'id'      => 'fy_event_location_type',
						'type'    => 'select',
						'options' => array(
							'Place'           => esc_html_x( 'Physical', 'type', 'forqy' ),
							'VirtualLocation' => esc_html_x( 'Online', 'type', 'forqy' ),
						),
					),
					array(
						'name' => esc_html_x( 'Name', 'type', 'forqy' ),
						'id'   => 'fy_event_location',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'Street', 'type', 'forqy' ),
						'id'   => 'fy_event_location_street',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'City', 'type', 'forqy' ),
						'id'   => 'fy_event_location_city',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'State / Province / Region', 'type', 'forqy' ),
						'id'   => 'fy_event_location_state',
						'type' => 'text',
					),
					array(
						'name'              => esc_html_x( 'Map', 'type', 'forqy' ),
						'desc'              => esc_html_x( 'The embed code from Google Maps or another map provider.', 'type', 'forqy' ),
						'id'                => 'fy_event_map_embed',
						'type'              => 'textarea',
						'rows'              => 5,
						'sanitize_callback' => 'forqy_sanitize_map',
					),
					array(
						'name' => esc_html_x( 'URL', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The URL of the online event, where people can join. This property is required if your event is happening online.', 'type', 'forqy' ),
						'id'   => 'fy_event_location_url',
						'type' => 'text',
					),
					array(
						'type' => 'heading',
						'name' => esc_html_x( 'Tickets', 'type', 'forqy' ),
					),
					array(
						'name'        => esc_html_x( 'Availability', 'type', 'forqy' ),
						'desc'        => esc_html_x( 'The availability of event tickets.', 'type', 'forqy' ),
						'placeholder' => esc_html_x( 'Select', 'type', 'forqy' ),
						'id'          => 'fy_event_availability',
						'type'        => 'select',
						'options'     => array(
							'InStock'  => esc_html_x( 'In Stock', 'type', 'forqy' ),
							'SoldOut'  => esc_html_x( 'Sold Out', 'type', 'forqy' ),
							'PreOrder' => esc_html_x( 'Pre Order', 'type', 'forqy' ),
						),
					),
					array(
						'name' => esc_html_x( 'Price', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The price including currency symbol, e.g. "$25".', 'type', 'forqy' ),
						'id'   => 'fy_event_price',
						'type' => 'text',
					),
					array(
						'name'       => esc_html_x( 'Price Currency', 'type', 'forqy' ),
						'desc'       => esc_html_x( 'The 3-letter currency code, e.g. "USD", "EUR", etc.', 'type', 'forqy' ),
						'id'         => 'fy_event_price_currency',
						'std'        => apply_filters( 'forqy_currency', $currency ),
						'type'       => 'text',
						'attributes' => array(
							'maxlength' => 3,
						),
					),
					array(
						'name' => esc_html_x( 'Button', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The button text. If you don\'t want to display the button, leave the field blank.', 'type', 'forqy' ),
						'id'   => 'fy_event_button',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'URL', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The URL to the page where people can buy tickets, e.g. "https://buytickets.now/".', 'type', 'forqy' ),
						'id'   => 'fy_event_button_url',
						'type' => 'text',
					),
					array(
						'type' => 'heading',
						'name' => esc_html_x( 'Performer', 'type', 'forqy' ),
					),
					array(
						'name'    => esc_html_x( 'Performer', 'type', 'forqy' ),
						'id'      => 'fy_event_performer',
						'type'    => 'select',
						'options' => array(
							'PerformingGroup' => esc_html_x( 'Performing Group', 'type', 'forqy' ),
							'MusicGroup'      => esc_html_x( 'Music Group', 'type', 'forqy' ),
							'DanceGroup'      => esc_html_x( 'Dance Group', 'type', 'forqy' ),
							'TheaterGroup'    => esc_html_x( 'Theater Group', 'type', 'forqy' ),
							'Person'          => esc_html_x( 'Person', 'type', 'forqy' ),
						),
					),
					array(
						'name' => esc_html_x( 'Name', 'type', 'forqy' ),
						'std'  => get_bloginfo( 'name' ),
						'id'   => 'fy_event_performer_name',
						'type' => 'text',
					),
					array(
						'type' => 'heading',
						'name' => esc_html_x( 'Organizer', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The person or organization that is hosting the event.', 'type', 'forqy' ),
					),
					array(
						'name'    => esc_html_x( 'Organizer', 'type', 'forqy' ),
						'id'      => 'fy_event_organizer',
						'type'    => 'select',
						'options' => array(
							'Organization' => esc_html_x( 'Organization', 'type', 'forqy' ),
							'Person'       => esc_html_x( 'Person', 'type', 'forqy' ),
						),
					),
					array(
						'name' => esc_html_x( 'Name', 'type', 'forqy' ),
						'id'   => 'fy_event_organizer_name',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'URL', 'type', 'forqy' ),
						'id'   => 'fy_event_organizer_url',
						'type' => 'text',
					),
				)
			);

		} else {

			$meta_boxes[] = array(
				'id'         => 'forqy-metabox-event',
				'title'      => esc_html_x( 'Event', 'type', 'forqy' ),
				'post_types' => array( 'event' ),
				'context'    => 'normal',
				'priority'   => 'high',
				'fields'     => array(
					array(
						'name'       => esc_html_x( 'Start Date', 'type', 'forqy' ),
						'desc'       => esc_html_x( 'Select the event start date.', 'type', 'forqy' ),
						'id'         => 'fy_event_date',
						'type'       => 'date',
						'std'        => $current_date,
						'js_options' => array(
							'dateFormat'      => $date_format,
							'showButtonPanel' => false,
						),
					),
					array(
						'name'       => esc_html_x( 'End Date', 'type', 'forqy' ),
						'desc'       => esc_html_x( 'Select the event end date. If the dates are the same, the end date will remain hidden.', 'type', 'forqy' ),
						'id'         => 'fy_event_date_end',
						'type'       => 'date',
						'std'        => $current_date,
						'js_options' => array(
							'dateFormat'      => $date_format,
							'showButtonPanel' => false,
						),
					),
					array(
						'name' => esc_html_x( 'Time', 'type', 'forqy' ),
						'id'   => 'fy_event_time',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'Status', 'type', 'forqy' ),
						'desc' => esc_html_x( 'Fill in the event status, e.g. "Tickets Available", "Sold Out", "Cancelled", etc.', 'type', 'forqy' ),
						'id'   => 'fy_event_status',
						'type' => 'text',
					),
					array(
						'type' => 'heading',
						'name' => esc_html_x( 'Location', 'type', 'forqy' ),
					),
					array(
						'name' => esc_html_x( 'Name', 'type', 'forqy' ),
						'std'  => get_bloginfo( 'name' ),
						'id'   => 'fy_event_location',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'Street', 'type', 'forqy' ),
						'id'   => 'fy_event_location_street',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'City', 'type', 'forqy' ),
						'id'   => 'fy_event_location_city',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'State / Province / Region', 'type', 'forqy' ),
						'id'   => 'fy_event_location_state',
						'type' => 'text',
					),
					array(
						'name'              => esc_html_x( 'Map', 'type', 'forqy' ),
						'desc'              => esc_html_x( 'The embed code from Google Maps or another map provider.', 'type', 'forqy' ),
						'id'                => 'fy_event_map_embed',
						'type'              => 'textarea',
						'rows'              => 8,
						'sanitize_callback' => 'forqy_sanitize_map',
					),
					array(
						'type' => 'heading',
						'name' => esc_html_x( 'Tickets', 'forqy' ),
					),
					array(
						'name'    => esc_html_x( 'Availability', 'type', 'forqy' ),
						'desc'    => esc_html_x( 'Select the availability of event tickets. Used for search engines only!', 'type', 'forqy' ),
						'id'      => 'fy_event_availability',
						'type'    => 'select',
						'options' => array(
							'InStock'             => esc_html_x( 'In Stock', 'type', 'forqy' ),
							'InStoreOnly'         => esc_html_x( 'In Store Only', 'type', 'forqy' ),
							'LimitedAvailability' => esc_html_x( 'Limited Availability', 'type', 'forqy' ),
							'OnlineOnly'          => esc_html_x( 'Online Only', 'type', 'forqy' ),
							'OutOfStock'          => esc_html_x( 'Out of Stock', 'type', 'forqy' ),
							'PreOrder'            => esc_html_x( 'Pre Order', 'type', 'forqy' ),
							'PreSale'             => esc_html_x( 'Pre Sale', 'type', 'forqy' ),
							'SoldOut'             => esc_html_x( 'Sold Out', 'type', 'forqy' ),
							'Discontinued'        => esc_html_x( 'Discontinued', 'type', 'forqy' ),
						),
					),
					array(
						'name' => esc_html_x( 'Ticket Price', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The price including currency symbol, e.g. "$25".', 'type', 'forqy' ),
						'id'   => 'fy_event_price',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'Ticket Button', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The button text. If you don\'t want to display the button, leave the field blank.', 'type', 'forqy' ),
						'id'   => 'fy_event_button',
						'type' => 'text',
					),
					array(
						'name' => esc_html_x( 'Ticket Button URL', 'type', 'forqy' ),
						'desc' => esc_html_x( 'The URL to the page where people can buy tickets, e.g. "https://buytickets.now/".', 'type', 'forqy' ),
						'id'   => 'fy_event_button_url',
						'type' => 'text',
					),
				),
			);

		}

		return $meta_boxes;

	}

	add_filter( 'rwmb_meta_boxes', 'forqy_metabox_event_register' );

}
