<?php

/*

Album Metabox

*/

// Exit If Accessed Directly
defined( 'ABSPATH' ) || exit;


if ( ! function_exists( 'forqy_metabox_album_register' ) ) {

	/**
	 * Register Metabox
	 *
	 * @param $meta_boxes
	 *
	 * @return mixed
	 */
	function forqy_metabox_album_register( $meta_boxes ) {

		$date_format  = 'yy/mm/dd';
		$current_date = date( 'Y/m/d' );

		$meta_boxes[] = array(
			'id'         => 'forqy-metabox-album-tracks',
			'title'      => esc_html_x( 'Tracks', 'type', 'forqy' ),
			'post_types' => array( 'album' ),
			'context'    => 'normal',
			'priority'   => 'high',
			'fields'     => array(
				array(
					'name'      => esc_html_x( 'Tracks', 'type', 'forqy' ),
					'desc'      => esc_html_x( 'Tracks of this album.', 'type', 'forqy' ),
					'id'        => 'fy_album_tracks',
					'type'      => 'file_advanced',
					'mime_type' => array(
						'audio/mpeg',
						'audio/mp3',
						'audio/ogg',
					),
				),
			),
		);

		$meta_boxes[] = array(
			'id'         => 'forqy-metabox-album',
			'title'      => esc_html_x( 'Album', 'type', 'forqy' ),
			'post_types' => array( 'album' ),
			'context'    => 'normal',
			'priority'   => 'high',
			'fields'     => array(
				array(
					'name' => esc_html_x( 'Artist', 'type', 'forqy' ),
					'std'  => get_bloginfo( 'name' ),
					'id'   => 'fy_album_artist',
					'type' => 'text',
				),
				array(
					'name' => esc_html_x( 'Artist URL', 'type', 'forqy' ),
					'desc' => esc_html_x( 'The artist URL, e.g. "https://artist.com/".', 'type', 'forqy' ),
					'id'   => 'fy_album_artist_url',
					'type' => 'text',
				),
				array(
					'name' => esc_html_x( 'Artist Bio', 'type', 'forqy' ),
					'desc' => esc_html_x( 'The short biography of the artist.', 'type', 'forqy' ),
					'id'   => 'fy_album_artist_bio',
					'type' => 'textarea',
					'rows' => 5,
				),
				array(
					'type' => 'divider',
				),
				array(
					'name'       => esc_html_x( 'Buttons', 'type', 'forqy' ),
					'desc'       => wp_kses( _x( 'Custom buttons to purchasing or listening to the album. Required format: <code>Text|URL</code>. Example: <code>Buy on iTunes|https://itunes.com/</code>.', 'type', 'forqy' ), array( 'code' => array() ) ),
					'id'         => 'fy_album_button',
					'type'       => 'text',
					'clone'      => true,
					'sort_clone' => true,
				),
				array(
					'type' => 'divider',
				),
				array(
					'name' => esc_html_x( 'Price', 'type', 'forqy' ),
					'desc' => esc_html_x( 'The price including currency symbol, e.g. "$25".', 'type', 'forqy' ),
					'id'   => 'fy_album_price',
					'type' => 'text',
				),
				array(
					'type' => 'divider',
				),
				array(
					'name' => esc_html_x( 'Label', 'type', 'forqy' ),
					'desc' => esc_html_x( 'The record label under which is the album released.', 'type', 'forqy' ),
					'id'   => 'fy_album_label',
					'type' => 'text',
				),
				array(
					'name' => esc_html_x( 'Label URL', 'type', 'forqy' ),
					'desc' => esc_html_x( 'The record label URL, e.g. "https://label.com/".', 'type', 'forqy' ),
					'id'   => 'fy_album_label_url',
					'type' => 'text',
				),
				array(
					'type' => 'divider',
				),
				array(
					'name' => esc_html_x( 'Status', 'type', 'forqy' ),
					'desc' => esc_html_x( 'The status, e.g. "Released", "Sold Out", etc.', 'type', 'forqy' ),
					'id'   => 'fy_album_status',
					'type' => 'text',
				),
				array(
					'name' => esc_html_x( 'Number', 'type', 'forqy' ),
					'desc' => esc_html_x( 'The catalog number under which is the album listed.', 'type', 'forqy' ),
					'id'   => 'fy_album_number',
					'type' => 'text',
				),
				array(
					'name'       => esc_html_x( 'Release Date', 'type', 'forqy' ),
					'desc'       => esc_html_x( 'The release date of the album.', 'type', 'forqy' ),
					'id'         => 'fy_album_date',
					'type'       => 'date',
					'std'        => $current_date,
					'js_options' => array(
						'dateFormat'      => $date_format,
						'showButtonPanel' => false,
					),
				),
				array(
					'name' => esc_html_x( 'Genre', 'type', 'forqy' ),
					'desc' => esc_html_x( 'Genres separated by commas, e.g. "Punk, Rock, Punk-rock", etc.', 'type', 'forqy' ),
					'id'   => 'fy_album_genre',
					'type' => 'text',
				),
				array(
					'type' => 'divider',
				),
				array(
					'name'       => esc_html_x( 'Meta', 'type', 'forqy' ),
					'desc'       => wp_kses( _x( 'Custom metadata. Required format: <code>Text|Value</code>', 'type', 'forqy' ), array( 'code' => array() ) ),
					'id'         => 'fy_album_meta',
					'type'       => 'text',
					'clone'      => true,
					'sort_clone' => true,
				),
			),
		);

		return $meta_boxes;

	}

	add_filter( 'rwmb_meta_boxes', 'forqy_metabox_album_register' );

}
