<?php

/*

Taximage

*/

// Get the source URL of the requested taxonomy term image

if ( ! function_exists( 'forqy_taxonomy_get_image_src' ) ) {

	function forqy_taxonomy_get_image_src( $tax_term, $size = 'thumbnail' ) {

		if ( ! is_object( $tax_term ) ) {
			return false;
		}

		$src = get_option( 'fy_tax_image_' . $tax_term->taxonomy . '_' . $tax_term->term_id );
		$tmp = false;

		if ( is_numeric( $src ) ) {

			$tmp = wp_get_attachment_image_src( $src, $size );

			if ( $tmp && ! is_wp_error( $tmp ) && is_array( $tmp ) && count( $tmp ) >= 3 ) {
				$tmp = array( 'ID' => $src, 'src' => $tmp[0], 'width' => $tmp[1], 'height' => $tmp[2] );
			} else {
				return false;
			}

		} else if ( ! empty( $src ) ) {

			$tmp = array( 'src' => $src );

		}

		if ( $tmp && ! is_wp_error( $tmp ) && is_array( $tmp ) && isset( $tmp['src'] ) ) {
			return $tmp;
		} else {
			return false;
		}

	}

}

// Get the html needed to display the taxonomy term image

if ( ! function_exists( 'forqy_taxonomy_get_image' ) ) {

	function forqy_taxonomy_get_image( $tax_term, $size = 'thumbnail' ) {

		$image = forqy_taxonomy_get_image_src( $tax_term, $size );

		if ( ! $image ) {
			return false;
		}

		return '<img src="' . $image['src'] . '" alt="' . $tax_term->name . '" class="taxonomy-term-image" loading="lazy">';

	}

}
