<?php

/*

Customize Forms

*/

if ( ! function_exists( 'forqy_types_add_section_slugs' ) ) {

	/**
	 * Add Section
	 *
	 * @param $wp_customize
	 */
	function forqy_types_add_section_slugs( $wp_customize ) {

		$wp_customize->add_section( 'slugs', array(
			'title'    => esc_html__( 'Slugs', 'forqy' ),
			'priority' => 181,
		) );

	}

	add_action( 'customize_register', 'forqy_types_add_section_slugs' );

}

if ( ! function_exists( 'forqy_types_add_settings_slugs' ) ) {

	/**
	 * Add Settings
	 *
	 * @param $wp_customize
	 */
	function forqy_types_add_settings_slugs( $wp_customize ) {

		// Menu
		if ( post_type_exists( 'menu' ) ) {
			$wp_customize->add_setting( 'fy_slug_menu_heading', array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_slug_menu', array(
				'default'           => 'item',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_slug_menu_section', array(
				'default'           => 'menu',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_slug_menu_ingredient', array(
				'default'           => 'ingredient',
				'sanitize_callback' => 'sanitize_text_field',
			) );
		}

		// Album
		if ( post_type_exists( 'album' ) ) {
			$wp_customize->add_setting( 'fy_slug_album_heading', array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_slug_album', array(
				'default'           => 'album',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_slug_album_category', array(
				'default'           => 'albums',
				'sanitize_callback' => 'sanitize_text_field',
			) );
		}

		// Event
		if ( post_type_exists( 'event' ) ) {
			$wp_customize->add_setting( 'fy_slug_event_heading', array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_slug_event', array(
				'default'           => 'event',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_slug_event_category', array(
				'default'           => 'events',
				'sanitize_callback' => 'sanitize_text_field',
			) );
		}

		// Gallery
		if ( post_type_exists( 'gallery' ) ) {
			$wp_customize->add_setting( 'fy_slug_gallery_heading', array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_slug_gallery', array(
				'default'           => 'gallery',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_slug_gallery_category', array(
				'default'           => 'galleries',
				'sanitize_callback' => 'sanitize_text_field',
			) );
		}

		// Portfolio
		if ( post_type_exists( 'project' ) ) {
			$wp_customize->add_setting( 'fy_slug_portfolio_heading', array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_slug_project', array(
				'default'           => 'project',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_slug_portfolio_category', array(
				'default'           => 'portfolio',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_slug_portfolio_tag', array(
				'default'           => 'portfolio-tag',
				'sanitize_callback' => 'sanitize_text_field',
			) );
		}

		// Review
		if ( post_type_exists( 'review' ) ) {
			$wp_customize->add_setting( 'fy_slug_review_heading', array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_slug_review', array(
				'default'           => 'review',
				'sanitize_callback' => 'sanitize_text_field',
			) );
		}

	}

	add_action( 'customize_register', 'forqy_types_add_settings_slugs' );

}

if ( ! function_exists( 'forqy_types_add_controls_slugs' ) ) {

	/**
	 * Add Controls
	 *
	 * @param $wp_customize
	 */
	function forqy_types_add_controls_slugs( $wp_customize ) {

		$url = get_admin_url( '', 'options-permalink.php' );

		// Menu

		if ( post_type_exists( 'menu' ) ) {
			if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
				$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_slug_menu_heading', array(
					'label'   => esc_html_x( 'Menu', 'type', 'forqy' ),
					'type'    => 'heading',
					'section' => 'slugs',
				) ) );
			}
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slug_menu', array(
				'label'       => esc_html_x( 'Menu Item', 'type', 'forqy' ),
				'description' => sprintf( wp_kses( _x( 'Fill in the name in the URL and then re-save <a href="%s">permalinks</a>. Default: "%s"', 'type', 'forqy' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( $url ), 'item' ),
				'settings'    => 'fy_slug_menu',
				'section'     => 'slugs',
			) ) );
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slug_menu_section', array(
				'label'       => esc_html_x( 'Menu Section', 'type', 'forqy' ),
				'description' => sprintf( wp_kses( _x( 'Fill in the name in the URL and then re-save <a href="%s">permalinks</a>. Default: "%s"', 'type', 'forqy' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( $url ), 'menu' ),
				'settings'    => 'fy_slug_menu_section',
				'section'     => 'slugs',
			) ) );
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slug_menu_ingredient', array(
				'label'       => esc_html_x( 'Menu Ingredient', 'type', 'forqy' ),
				'description' => sprintf( wp_kses( _x( 'Fill in the name in the URL and then re-save <a href="%s">permalinks</a>. Default: "%s"', 'type', 'forqy' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( $url ), 'ingredient' ),
				'settings'    => 'fy_slug_menu_ingredient',
				'section'     => 'slugs',
			) ) );
		}

		// Album

		if ( post_type_exists( 'album' ) ) {
			if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
				$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_slug_album_heading', array(
					'label'   => esc_html_x( 'Albums', 'type', 'forqy' ),
					'type'    => 'heading',
					'section' => 'slugs',
				) ) );
			}
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slug_album', array(
				'label'       => esc_html_x( 'Album', 'type', 'forqy' ),
				'description' => sprintf( wp_kses( _x( 'Fill in the name in the URL and then re-save <a href="%s">permalinks</a>. Default: "%s"', 'type', 'forqy' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( $url ), 'album' ),
				'settings'    => 'fy_slug_album',
				'section'     => 'slugs',
			) ) );
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slug_album_category', array(
				'label'       => esc_html_x( 'Albums', 'type', 'forqy' ),
				'description' => sprintf( wp_kses( _x( 'Fill in the name in the URL and then re-save <a href="%s">permalinks</a>. Default: "%s"', 'type', 'forqy' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( $url ), 'albums' ),
				'settings'    => 'fy_slug_album_category',
				'section'     => 'slugs',
			) ) );
		}

		// Event

		if ( post_type_exists( 'event' ) ) {
			if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
				$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_slug_event_heading', array(
					'label'   => esc_html_x( 'Events', 'type', 'forqy' ),
					'type'    => 'heading',
					'section' => 'slugs',
				) ) );
			}
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slug_event', array(
				'label'       => esc_html_x( 'Event', 'type', 'forqy' ),
				'description' => sprintf( wp_kses( _x( 'Fill in the name in the URL and then re-save <a href="%s">permalinks</a>. Default: "%s"', 'type', 'forqy' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( $url ), 'event' ),
				'settings'    => 'fy_slug_event',
				'section'     => 'slugs',
			) ) );
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slug_event_category', array(
				'label'       => esc_html_x( 'Events', 'type', 'forqy' ),
				'description' => sprintf( wp_kses( _x( 'Fill in the name in the URL and then re-save <a href="%s">permalinks</a>. Default: "%s"', 'type', 'forqy' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( $url ), 'events' ),
				'settings'    => 'fy_slug_event_category',
				'section'     => 'slugs',
			) ) );
		}

		// Portfolio

		if ( post_type_exists( 'project' ) ) {
			if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
				$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_slug_portfolio_heading', array(
					'label'   => esc_html_x( 'Portfolio', 'type', 'forqy' ),
					'type'    => 'heading',
					'section' => 'slugs',
				) ) );
			}
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slug_project', array(
				'label'       => esc_html_x( 'Project', 'type', 'forqy' ),
				'description' => sprintf( wp_kses( _x( 'Fill in the name in the URL and then re-save <a href="%s">permalinks</a>. Default: "%s"', 'type', 'forqy' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( $url ), 'project' ),
				'settings'    => 'fy_slug_project',
				'section'     => 'slugs',
			) ) );
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slug_portfolio_category', array(
				'label'       => esc_html_x( 'Category', 'type', 'forqy' ),
				'description' => sprintf( wp_kses( _x( 'Fill in the name in the URL and then re-save <a href="%s">permalinks</a>. Default: "%s"', 'type', 'forqy' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( $url ), 'portfolio' ),
				'settings'    => 'fy_slug_portfolio_category',
				'section'     => 'slugs',
			) ) );
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slug_portfolio_tag', array(
				'label'       => esc_html_x( 'Tag', 'type', 'forqy' ),
				'description' => sprintf( wp_kses( _x( 'Fill in the name in the URL and then re-save <a href="%s">permalinks</a>. Default: "%s"', 'type', 'forqy' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( $url ), 'portfolio-tag' ),
				'settings'    => 'fy_slug_portfolio_tag',
				'section'     => 'slugs',
			) ) );
		}

		// Gallery

		if ( post_type_exists( 'gallery' ) ) {
			if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
				$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_slug_gallery_heading', array(
					'label'   => esc_html_x( 'Gallery', 'type', 'forqy' ),
					'type'    => 'heading',
					'section' => 'slugs',
				) ) );
			}
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slug_gallery', array(
				'label'       => esc_html_x( 'Gallery', 'type', 'forqy' ),
				'description' => sprintf( wp_kses( _x( 'Fill in the name in the URL and then re-save <a href="%s">permalinks</a>. Default: "%s"', 'type', 'forqy' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( $url ), 'gallery' ),
				'settings'    => 'fy_slug_gallery',
				'section'     => 'slugs',
			) ) );
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slug_gallery_category', array(
				'label'       => esc_html_x( 'Galleries', 'type', 'forqy' ),
				'description' => sprintf( wp_kses( _x( 'Fill in the name in the URL and then re-save <a href="%s">permalinks</a>. Default: "%s"', 'type', 'forqy' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( $url ), 'galleries' ),
				'settings'    => 'fy_slug_gallery_category',
				'section'     => 'slugs',
			) ) );
		}

		// Review

		if ( post_type_exists( 'review' ) ) {
			if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
				$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_slug_review_heading', array(
					'label'   => esc_html_x( 'Review', 'type', 'forqy' ),
					'type'    => 'heading',
					'section' => 'slugs',
				) ) );
			}
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slug_review', array(
				'label'       => esc_html_x( 'Review', 'type', 'forqy' ),
				'description' => sprintf( wp_kses( _x( 'Fill in the name in the URL and then re-save <a href="%s">permalinks</a>. Default: "%s"', 'type', 'forqy' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( $url ), 'review' ),
				'settings'    => 'fy_slug_review',
				'section'     => 'slugs',
			) ) );
		}

	}

	add_action( 'customize_register', 'forqy_types_add_controls_slugs' );

}
