/*jslint browser this:true long:true */
/*global window, jQuery, wp */

/**
 * Gallery Metabox
 * @version 1.0.2
 * @requires jQuery
 */

(function ($) {
    "use strict";

    $(document).ready(function ($) {

        // Media Uploader

        let galleryUploader;

        const galleryMetabox = $("#forqy-metabox-gallery");

        const galleryImages = galleryMetabox.find(".js-gallery-images");
        const galleryButtonAdd = galleryMetabox.find(".js-gallery-image-add");

        /**
         * Reset Index
         */

        function forqyGalleryResetIndex() {

            galleryImages.find("li").each(function (i) {
                $(this).find("input:hidden").attr("name", "fy-gallery-images[" + i + "]");
            });

        }

        /**
         * Remove Image
         */

        function forqyGalleryRemoveImage() {

            $(document).on("click", ".fy-gallery-image-remove", function (e) {
                e.preventDefault();

                $(this).parents("li").remove();

                forqyGalleryResetIndex();
            });

        }

        /**
         * Make Sortable
         */

        function forqyGalleryMakeSortable() {

            galleryImages.sortable({
                opacity: 1,
                stop: function () {
                    forqyGalleryResetIndex();
                }
            });

        }

        /**
         * Init Uploader
         */

        galleryButtonAdd.on("click", function (e) {
            e.preventDefault();

            if (galleryUploader) {
                galleryUploader.close();
            }

            galleryUploader = wp.media.frames.file_frame = wp.media({
                title: $(this).data("uploader-title"),
                button: {
                    text: $(this).data("uploader-button-text")
                },
                multiple: true
            });

            galleryUploader.on("select", function () {
                const listIndex = galleryImages.find("li").index(galleryImages.find("li:last-child"));
                const selection = galleryUploader.state().get("selection");

                selection.map(function (attachment, i) {
                    attachment = attachment.toJSON();
                    i = listIndex + (i + 1);

                    const inputHiddenHtml = '<input type="hidden" name="fy-gallery-images[' + i + ']" value="' + attachment.id + '">';
                    const removeButtonHtml = '<button class="fy-gallery-image-remove js-gallery-image-remove button"><svg class="icon" width="24" height="24" viewBox="0 0 24 24"><polygon points="19,6.4 17.6,5 12,10.6 6.4,5 5,6.4 10.6,12 5,17.6 6.4,19 12,13.4 17.6,19 19,17.6 13.4,12"></polygon></svg></button>';

                    galleryImages.append('<li>' + inputHiddenHtml + '<div class="fy-gallery-image"><img class="image-preview" src="' + attachment.url + '" alt="">' + removeButtonHtml + '</div></li>');
                });
            });

            forqyGalleryRemoveImage();
            forqyGalleryMakeSortable();

            galleryUploader.open();

        });

        forqyGalleryRemoveImage();
        forqyGalleryMakeSortable();

    });

}(jQuery));