<?php

/**
 * FORQY Socials
 *
 * @version 1.2.3
 * @author  FORQY
 * @url     https://forqy.website/
 * @license GPL-3.0-or-later
 */

require dirname( __FILE__ ) . '/icons.php';
require dirname( __FILE__ ) . '/profiles.php';

// Customize
require dirname( __FILE__ ) . '/customize/socials.php'; // 141


if ( ! function_exists( 'forqy_socials' ) ) {

	/**
     * Template
     *
	 * @param bool $icons
	 * @param string $target
	 */
	function forqy_socials( bool $icons = true, string $target = '_blank' ) {

		// Get
		$socials = function_exists( 'forqy_socials_profiles' ) ? forqy_socials_profiles() : array();

		// Sort
		asort( $socials );

		// Write
		if ( ! empty( $socials ) ) { ?>
            <ul>
				<?php foreach ( $socials as $key => $value ) {

					$title = $value['title'];
					$url   = $value['url'];
					$icon  = $value['icon'];

					if ( ! empty( $url ) ) { ?>
                        <li class="fy-social-<?php echo esc_attr( $key ); ?>">
                            <a href="<?php echo esc_url( $url ); ?>"
                               title="<?php echo esc_attr( $title ); ?>"
                               target="<?php echo esc_attr( $target ); ?>"
                               rel="noopener">
								<?php if ( $icons ) { ?>
                                    <div class="fy-icon">
										<?php echo wp_kses( $icon, forqy_socials_icon_kses() ); ?>
                                    </div>
								<?php } else {
									echo esc_html( $title );
								} ?>
                                <span class="screen-reader-text"><?php echo esc_html_x( 'New Window', 'link to a new window', 'forqy' ); ?></span>
                            </a>
                        </li>
					<?php }
				} ?>
            </ul>
		<?php }

	}

}

if ( ! function_exists( 'forqy_socials_microdata' ) ) {

	/**
	 * Microdata
	 */
	function forqy_socials_microdata() {

		// Get Profiles
		$socials = function_exists( 'forqy_socials_profiles' ) ? forqy_socials_profiles() : array();

		// Sort
		asort( $socials );

		// Write
		if ( ! empty( $socials ) ) {

			foreach ( $socials as $key => $value ) {

				$url = $value['url'];

				if ( ! empty( $url ) ) { ?>
                    <link itemprop="sameAs" href="<?php echo esc_url( $url ); ?>">
				<?php }

			}

		}

	}

}
