<?php

/*
====================================================================================================
Social Share
====================================================================================================
*/

if ( ! function_exists( 'forqy_share' ) ) {

	/**
	 * Share
	 */
	function forqy_share() {
		$post_title = get_the_title();

		if ( get_theme_mod( 'fy_share' ) != 'disabled' ) { ?>

            <ul>
                <li class="fy-share-title"><?php esc_html_e( 'Share:', 'forqy' ); ?></li>

				<?php if ( get_theme_mod( 'fy_share_twitter' ) != 'false' ) {
					$title = __( 'Tweet', 'forqy' );
					?>
                    <li class="fy-share-twitter fy-social-twitter">
                        <a href="<?php echo esc_url( __( 'https://twitter.com/intent/tweet?url=', 'forqy' ) . get_the_permalink() . '&amp;text=' . str_replace( " ", "%20", $post_title ) ); ?>"
                           title="<?php echo esc_attr( $title ); ?>"
                           onclick="window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600'); return false;">
                            <div class="fy-icon">
								<?php require dirname( __FILE__ ) . '/icons/twitter.php'; ?>
                                <span class="screen-reader-text"><?php echo esc_html( $title ); ?></span>
                            </div>
                        </a>
                    </li>
				<?php }

				if ( get_theme_mod( 'fy_share_facebook' ) != 'false' ) {
					$title = __( 'Share on Facebook', 'forqy' );
					?>
                    <li class="fy-share-facebook fy-social-facebook">
                        <a href="<?php echo esc_url( __( 'https://www.facebook.com/sharer/sharer.php?u=', 'forqy' ) . get_the_permalink() . '&amp;title=' . str_replace( " ", "%20", $post_title ) ); ?>"
                           title="<?php echo esc_attr( $title ); ?>"
                           onclick="window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600'); return false;">
                            <div class="fy-icon">
								<?php require dirname( __FILE__ ) . '/icons/facebook.php'; ?>
                                <span class="screen-reader-text"><?php echo esc_html( $title ); ?></span>
                            </div>
                        </a>
                    </li>
				<?php }

				if ( has_post_thumbnail() && get_theme_mod( 'fy_share_pinterest' ) != 'false' ) {
					$post_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
					$title      = __( 'Share on Pinterest', 'forqy' );
					?>
                    <li class="fy-share-pinterest fy-social-pinterest">
                        <a href="<?php echo esc_url( __( 'https://pinterest.com/pin/create/button/?url=', 'forqy' ) . get_the_permalink() . isset( $post_image[0] ) ? '&amp;media=' . $post_image[0] : '' ); ?>"
                           title="<?php echo esc_attr( $title ); ?>"
                           onclick="window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600'); return false;">
                            <div class="fy-icon">
								<?php require dirname( __FILE__ ) . '/icons/pinterest.php'; ?>
                                <span class="screen-reader-text"><?php echo esc_html( $title ); ?></span>
                            </div>
                        </a>
                    </li>
				<?php }

				if ( get_theme_mod( 'fy_share_email' ) != 'false' ) {
					$title   = __( 'Share by Email', 'forqy' );
					$subject = str_replace( ' ', '%20', get_the_title() );
					?>
                    <li class="fy-share-email fy-social-email">
                        <a href="mailto:?subject=<?php echo esc_attr( urlencode( $subject ) ); ?>&amp;body=<?php the_permalink(); ?>"
                           title="<?php echo esc_attr( $title ); ?>">
                            <div class="fy-icon">
								<?php require dirname( __FILE__ ) . '/icons/email.php'; ?>
                                <span class="screen-reader-text"><?php echo esc_html( $title ); ?></span>
                            </div>
                        </a>
                    </li>
				<?php } ?>
            </ul>

		<?php }

	}

}
