<?php

/*

Socials - Profiles

*/

if ( ! function_exists( 'forqy_socials_profiles' ) ) {

	/**
	 * Social Profiles
	 *
	 * @param array $socials
	 *
	 * @return mixed
	 */
	function forqy_socials_profiles( array $socials = array() ) {

		// General

		$socials['twitter'] = array(
			'order' => '100',
			'id'    => 'fy_twitter',
			'title' => __( 'Twitter', 'forqy' ),
			'url'   => get_theme_mod( 'fy_twitter' ),
			'icon'  => forqy_socials_icon( 'twitter' ),
		);

		$socials['instagram'] = array(
			'order' => '105',
			'id'    => 'fy_instagram',
			'title' => __( 'Instagram', 'forqy' ),
			'url'   => get_theme_mod( 'fy_instagram' ),
			'icon'  => forqy_socials_icon( 'instagram' ),
		);

		$socials['facebook'] = array(
			'order' => '110',
			'id'    => 'fy_facebook',
			'title' => __( 'Facebook', 'forqy' ),
			'url'   => get_theme_mod( 'fy_facebook' ),
			'icon'  => forqy_socials_icon( 'facebook' ),
		);

		$socials['tiktok'] = array(
			'order' => '115',
			'id'    => 'fy_tiktok',
			'title' => __( 'TikTok', 'forqy' ),
			'url'   => get_theme_mod( 'fy_tiktok' ),
			'icon'  => forqy_socials_icon( 'tiktok' ),
		);

		$socials['linkedin'] = array(
			'order' => '120',
			'id'    => 'fy_linkedin',
			'title' => __( 'LinkedIn', 'forqy' ),
			'url'   => get_theme_mod( 'fy_linkedin' ),
			'icon'  => forqy_socials_icon( 'linkedin' ),
		);

		$socials['pinterest'] = array(
			'order' => '125',
			'id'    => 'fy_pinterest',
			'title' => __( 'Pinterest', 'forqy' ),
			'url'   => get_theme_mod( 'fy_pinterest' ),
			'icon'  => forqy_socials_icon( 'pinterest' ),
		);

		$socials['messenger'] = array(
			'order' => '130',
			'id'    => 'fy_messenger',
			'title' => __( 'Messenger', 'forqy' ),
			'url'   => get_theme_mod( 'fy_messenger' ),
			'icon'  => forqy_socials_icon( 'messenger' ),
		);

		$socials['whatsapp'] = array(
			'order' => '135',
			'id'    => 'fy_whatsapp',
			'title' => __( 'WhatsApp', 'forqy' ),
			'url'   => get_theme_mod( 'fy_whatsapp' ),
			'icon'  => forqy_socials_icon( 'whatsapp' ),
		);

		$socials['snapchat'] = array(
			'order' => '140',
			'id'    => 'fy_snapchat',
			'title' => __( 'Snapchat', 'forqy' ),
			'url'   => get_theme_mod( 'fy_snapchat' ),
			'icon'  => forqy_socials_icon( 'snapchat' ),
		);

		$socials['slack'] = array(
			'order' => '145',
			'id'    => 'fy_slack',
			'title' => __( 'Slack', 'forqy' ),
			'url'   => get_theme_mod( 'fy_slack' ),
			'icon'  => forqy_socials_icon( 'slack' ),
		);

		// Multimedia

		$socials['youtube'] = array(
			'order' => '200',
			'id'    => 'fy_youtube',
			'title' => __( 'YouTube', 'forqy' ),
			'url'   => get_theme_mod( 'fy_youtube' ),
			'icon'  => forqy_socials_icon( 'youtube' ),
		);

		$socials['vimeo'] = array(
			'order' => '205',
			'id'    => 'fy_vimeo',
			'title' => __( 'Vimeo', 'forqy' ),
			'url'   => get_theme_mod( 'fy_vimeo' ),
			'icon'  => forqy_socials_icon( 'vimeo' ),
		);

		$socials['spotify'] = array(
			'order' => '210',
			'id'    => 'fy_spotify',
			'title' => __( 'Spotify', 'forqy' ),
			'url'   => get_theme_mod( 'fy_spotify' ),
			'icon'  => forqy_socials_icon( 'spotify' ),
		);

		$socials['applemusic'] = array(
			'order' => '215',
			'id'    => 'fy_applemusic',
			'title' => __( 'Apple Music', 'forqy' ),
			'url'   => get_theme_mod( 'fy_applemusic' ),
			'icon'  => forqy_socials_icon( 'applemusic' ),
		);

		$socials['itunes'] = array(
			'order' => '220',
			'id'    => 'fy_itunes',
			'title' => __( 'iTunes', 'forqy' ),
			'url'   => get_theme_mod( 'fy_itunes' ),
			'icon'  => forqy_socials_icon( 'itunes' ),
		);

		$socials['soundcloud'] = array(
			'order' => '225',
			'id'    => 'fy_soundcloud',
			'title' => __( 'SoundCloud', 'forqy' ),
			'url'   => get_theme_mod( 'fy_soundcloud' ),
			'icon'  => forqy_socials_icon( 'soundcloud' ),
		);

		$socials['beatport'] = array(
			'order' => '230',
			'id'    => 'fy_beatport',
			'title' => __( 'Beatport', 'forqy' ),
			'url'   => get_theme_mod( 'fy_beatport' ),
			'icon'  => forqy_socials_icon( 'beatport' ),
		);

		$socials['mixcloud'] = array(
			'order' => '235',
			'id'    => 'fy_mixcloud',
			'title' => __( 'Mixcloud', 'forqy' ),
			'url'   => get_theme_mod( 'fy_mixcloud' ),
			'icon'  => forqy_socials_icon( 'mixcloud' ),
		);

		$socials['bandcamp'] = array(
			'order' => '240',
			'id'    => 'fy_bandcamp',
			'title' => __( 'Bandcamp', 'forqy' ),
			'url'   => get_theme_mod( 'fy_bandcamp' ),
			'icon'  => forqy_socials_icon( 'bandcamp' ),
		);

		$socials['deezer'] = array(
			'order' => '245',
			'id'    => 'fy_deezer',
			'title' => __( 'Deezer', 'forqy' ),
			'url'   => get_theme_mod( 'fy_deezer' ),
			'icon'  => forqy_socials_icon( 'deezer' ),
		);

		$socials['tidal'] = array(
			'order' => '250',
			'id'    => 'fy_tidal',
			'title' => __( 'Tidal', 'forqy' ),
			'url'   => get_theme_mod( 'fy_tidal' ),
			'icon'  => forqy_socials_icon( 'tidal' ),
		);

		$socials['reverbnation'] = array(
			'order' => '255',
			'id'    => 'fy_reverbnation',
			'title' => __( 'ReverbNation', 'forqy' ),
			'url'   => get_theme_mod( 'fy_reverbnation' ),
			'icon'  => forqy_socials_icon( 'reverbnation' ),
		);

		$socials['bandsintown'] = array(
			'order' => '260',
			'id'    => 'fy_bandsintown',
			'title' => __( 'Bandsintown', 'forqy' ),
			'url'   => get_theme_mod( 'fy_bandsintown' ),
			'icon'  => forqy_socials_icon( 'bandsintown' ),
		);

		// Gaming

		$socials['twitch'] = array(
			'order' => '265',
			'id'    => 'fy_twitch',
			'title' => __( 'Twitch', 'forqy' ),
			'url'   => get_theme_mod( 'fy_twitch' ),
			'icon'  => forqy_socials_icon( 'twitch' ),
		);

		$socials['discord'] = array(
			'order' => '270',
			'id'    => 'fy_discord',
			'title' => __( 'Discord', 'forqy' ),
			'url'   => get_theme_mod( 'fy_discord' ),
			'icon'  => forqy_socials_icon( 'discord' ),
		);

		// Design

		$socials['dribbble'] = array(
			'order' => '300',
			'id'    => 'fy_dribbble',
			'title' => __( 'Dribbble', 'forqy' ),
			'url'   => get_theme_mod( 'fy_dribbble' ),
			'icon'  => forqy_socials_icon( 'dribbble' ),
		);

		$socials['behance'] = array(
			'order' => '300',
			'id'    => 'fy_behance',
			'title' => __( 'Behance', 'forqy' ),
			'url'   => get_theme_mod( 'fy_behance' ),
			'icon'  => forqy_socials_icon( 'behance' ),
		);

		$socials['codepen'] = array(
			'order' => '305',
			'id'    => 'fy_codepen',
			'title' => __( 'CodePen', 'forqy' ),
			'url'   => get_theme_mod( 'fy_codepen' ),
			'icon'  => forqy_socials_icon( 'codepen' ),
		);

		$socials['unsplash'] = array(
			'order' => '310',
			'id'    => 'fy_unsplash',
			'title' => __( 'Unsplash', 'forqy' ),
			'url'   => get_theme_mod( 'fy_unsplash' ),
			'icon'  => forqy_socials_icon( 'unsplash' ),
		);

		$socials['github'] = array(
			'order' => '315',
			'id'    => 'fy_github',
			'title' => __( 'GitHub', 'forqy' ),
			'url'   => get_theme_mod( 'fy_github' ),
			'icon'  => forqy_socials_icon( 'github' ),
		);

		$socials['gitlab'] = array(
			'order' => '320',
			'id'    => 'fy_gitlab',
			'title' => __( 'GitLab', 'forqy' ),
			'url'   => get_theme_mod( 'fy_gitlab' ),
			'icon'  => forqy_socials_icon( 'gitlab' ),
		);

		$socials['stackoverflow'] = array(
			'order' => '325',
			'id'    => 'fy_stackoverflow',
			'title' => __( 'Stack Overflow', 'forqy' ),
			'url'   => get_theme_mod( 'fy_stackoverflow' ),
			'icon'  => forqy_socials_icon( 'stackoverflow' ),
		);

		$socials['producthunt'] = array(
			'order' => '330',
			'id'    => 'fy_producthunt',
			'title' => __( 'Product Hunt', 'forqy' ),
			'url'   => get_theme_mod( 'fy_producthunt' ),
			'icon'  => forqy_socials_icon( 'producthunt' ),
		);

		$socials['uplabs'] = array(
			'order' => '335',
			'id'    => 'fy_uplabs',
			'title' => __( 'UpLabs', 'forqy' ),
			'url'   => get_theme_mod( 'fy_uplabs' ),
			'icon'  => forqy_socials_icon( 'uplabs' ),
		);

		$socials['wordpress'] = array(
			'order' => '340',
			'id'    => 'fy_wordpress',
			'title' => __( 'WordPress', 'forqy' ),
			'url'   => get_theme_mod( 'fy_wordpress' ),
			'icon'  => forqy_socials_icon( 'wordpress' ),
		);

		// Restaurant

		$socials['tripadvisor'] = array(
			'order' => '400',
			'id'    => 'fy_tripadvisor',
			'title' => __( 'TripAdvisor', 'forqy' ),
			'url'   => get_theme_mod( 'fy_tripadvisor' ),
			'icon'  => forqy_socials_icon( 'tripadvisor' ),
		);

		$socials['foursquare'] = array(
			'order' => '405',
			'id'    => 'fy_foursquare',
			'title' => __( 'Foursquare', 'forqy' ),
			'url'   => get_theme_mod( 'fy_foursquare' ),
			'icon'  => forqy_socials_icon( 'foursquare' ),
		);

		$socials['yelp'] = array(
			'order' => '410',
			'id'    => 'fy_yelp',
			'title' => __( 'Yelp', 'forqy' ),
			'url'   => get_theme_mod( 'fy_yelp' ),
			'icon'  => forqy_socials_icon( 'yelp' ),
		);

		$socials['zomato'] = array(
			'order' => '415',
			'id'    => 'fy_zomato',
			'title' => __( 'Zomato', 'forqy' ),
			'url'   => get_theme_mod( 'fy_zomato' ),
			'icon'  => forqy_socials_icon( 'zomato' ),
		);

		$socials['zagat'] = array(
			'order' => '420',
			'id'    => 'fy_zagat',
			'title' => __( 'Zagat', 'forqy' ),
			'url'   => get_theme_mod( 'fy_zagat' ),
			'icon'  => forqy_socials_icon( 'zagat' ),
		);

		// Other

		$socials['reddit'] = array(
			'order' => '500',
			'id'    => 'fy_reddit',
			'title' => __( 'Reddit', 'forqy' ),
			'url'   => get_theme_mod( 'fy_reddit' ),
			'icon'  => forqy_socials_icon( 'reddit' ),
		);

		$socials['amazon'] = array(
			'order' => '505',
			'id'    => 'fy_amazon',
			'title' => __( 'Amazon', 'forqy' ),
			'url'   => get_theme_mod( 'fy_amazon' ),
			'icon'  => forqy_socials_icon( 'amazon' ),
		);

		return apply_filters( 'forqy_socials', $socials );

	}

}

if ( ! function_exists( 'forqy_socials_exists' ) ) {

	/**
	 * Check If Socials Exists
	 *
	 * @return bool
	 */
	function forqy_socials_exists(): bool {

		// Get
		$socials = function_exists( 'forqy_socials_profiles' ) ? forqy_socials_profiles() : array();

		// Check
		foreach ( $socials as $key => $value ) {
			if ( isset( $value['url'] ) && ! empty( $value['url'] ) ) {
				return true;
			}
		}

		return false;

	}

}
