<?php

/*

Socials - Icon

*/

if ( ! function_exists( 'forqy_socials_icon' ) ) {

	/**
	 * Get Icon
	 *
	 * @param string $icon
	 *
	 * @return false|string
	 */
	function forqy_socials_icon( string $icon = '' ) {

		ob_start();
		require dirname( __FILE__ ) . '/icons/' . sanitize_file_name( $icon ) . '.php';

		return ob_get_clean();

	}

}

if ( ! function_exists( 'forqy_socials_icon_kses' ) ) {

	/**
	 * Sanitize Icon
	 *
	 * @return array
	 */
	function forqy_socials_icon_kses(): array {

		return array(

			// Image
			'img'      => array(
				'id'     => true,
				'class'  => true,
				'src'    => true,
				'alt'    => true,
				'title'  => true,
				'width'  => true,
				'height' => true,
			),

			// Svg
			'svg'      => array(
				'id'          => true,
				'class'       => true,
				'width'       => true,
				'height'      => true,
				'version'     => true,
				'xmlns'       => true,
				'viewbox'     => true,
				'role'        => true,
				'aria-hidden' => true,
				'aria-label'  => true,
			),
			'title'    => array(),
			'path'     => array(
				'd'          => true,
				'fill'       => true,
				'stroke'     => true,
				'pathlength' => true,
			),
			'polygon'  => array(
				'points'     => true,
				'fill'       => true,
				'stroke'     => true,
				'pathlength' => true,
			),
			'polyline' => array(
				'points'     => true,
				'fill'       => true,
				'stroke'     => true,
				'pathlength' => true,
			),
			'line'     => array(
				'x1'         => true,
				'x2'         => true,
				'y1'         => true,
				'y2'         => true,
				'pathlength' => true,
			),
			'circle'   => array(
				'cx'         => true,
				'cy'         => true,
				'r'          => true,
				'pathlength' => true,
			),
			'ellipse'  => array(
				'cx'         => true,
				'cy'         => true,
				'rx'         => true,
				'ry'         => true,
				'pathlength' => true,
			),
			'rect'     => array(
				'x'          => true,
				'y'          => true,
				'rx'         => true,
				'ry'         => true,
				'width'      => true,
				'height'     => true,
				'pathlength' => true,
			),

		);

	}

}
