<?php

/*

Customize Socials

*/

if ( ! function_exists( 'forqy_socials_customize_add_section' ) ) {

	/**
	 * Add Section
	 *
	 * @param $wp_customize
	 */
	function forqy_socials_customize_add_section( $wp_customize ) {

		$wp_customize->add_section( 'socials', array(
			'title'       => esc_html_x( 'Socials', 'socials', 'forqy' ),
			'description' => esc_html_x( 'Fill in URLs to your social profiles.', 'socials', 'forqy' ),
			'priority'    => 141,
		) );

	}

	add_action( 'customize_register', 'forqy_socials_customize_add_section' );

}

if ( ! function_exists( 'forqy_socials_customize_add_settings' ) ) {

	/**
	 * Add Settings
	 *
	 * @param $wp_customize
	 */
	function forqy_socials_customize_add_settings( $wp_customize ) {

		if ( current_theme_supports( 'forqy-socials' ) ) {

			/**
			 * Socials
			 */

			// Get
			$socials = function_exists( 'forqy_socials_profiles' ) ? forqy_socials_profiles() : array();

			// Sort
			asort( $socials );

			// Write
			if ( ! empty( $socials ) ) {
				foreach ( $socials as $key => $value ) {

					// Add Setting
					$wp_customize->add_setting( $value['id'], array(
						'transport'         => 'refresh',
						'sanitize_callback' => 'sanitize_text_field',
					) );
				}
			}

			$wp_customize->selective_refresh->add_partial( 'fy_twitter', array(
				'selector' => '.cs-socials'
			) );

			/**
			 * Share
			 */

			$wp_customize->add_setting( 'fy_share_heading', array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_share', array(
				'default'           => 'enabled',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );

			$wp_customize->selective_refresh->add_partial( 'fy_share', array(
				'selector' => '.cs-share'
			) );

		}

	}

	add_action( 'customize_register', 'forqy_socials_customize_add_settings' );

}

if ( ! function_exists( 'forqy_socials_customize_add_controls' ) ) {

	/**
	 * Add Controls
	 *
	 * @param $wp_customize
	 */
	function forqy_socials_customize_add_controls( $wp_customize ) {

		if ( current_theme_supports( 'forqy-socials' ) ) {

			/**
			 * Socials
			 */

			// Get
			$socials = function_exists( 'forqy_socials_profiles' ) ? forqy_socials_profiles() : array();

			// Sort
			asort( $socials );

			// Write
			if ( ! empty( $socials ) ) {
				foreach ( $socials as $key => $value ) {

					// Add Control
					$wp_customize->add_control( new WP_Customize_Control( $wp_customize, $value['id'], array(
						'label'    => $value['title'],
						'settings' => $value['id'],
						'section'  => 'socials',
					) ) );
				}
			}

			/**
			 * Share
			 */

			if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
				$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_share_heading', array(
					'label'   => esc_html_x( 'Share', 'socials', 'forqy' ),
					'type'    => 'heading',
					'section' => 'socials',
				) ) );
			}
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_share', array(
				'label'    => esc_html_x( 'Share', 'socials', 'forqy' ),
				'settings' => 'fy_share',
				'section'  => 'socials',
				'type'     => 'select',
				'choices'  => array(
					'enabled'  => esc_html_x( 'Enabled', 'option', 'forqy' ),
					'disabled' => esc_html_x( 'Disabled', 'option', 'forqy' ),
				),
			) ) );

		}

	}

	add_action( 'customize_register', 'forqy_socials_customize_add_controls' );

}
