<?php

/*

Customize Socials
TODO Deprecated

*/

if ( ! function_exists( 'forqy_socials_add_section_socials_restaurant' ) ) {

	/**
	 * Add Section
	 *
	 * @param $wp_customize
	 */
	function forqy_socials_add_section_socials_restaurant( $wp_customize ) {

		$wp_customize->add_section( 'socials_restaurant', array(
			'title'       => esc_html_x( 'Socials', 'socials', 'forqy' ),
			'description' => esc_html_x( 'Fill in URLs to your social profiles.', 'socials', 'forqy' ),
			'priority'    => 141,
		) );

	}

	add_action( 'customize_register', 'forqy_socials_add_section_socials_restaurant' );

}

if ( ! function_exists( 'forqy_socials_add_settings_socials_restaurant' ) ) {

	/**
	 * Add Settings
	 *
	 * @param $wp_customize
	 */
	function forqy_socials_add_settings_socials_restaurant( $wp_customize ) {

		if ( ! current_theme_supports( 'forqy-socials' ) ) {

			$wp_customize->selective_refresh->add_partial( 'fy_twitter', array(
				'selector' => '.cs-socials'
			) );

			// Socials
			$wp_customize->add_setting( 'fy_twitter', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_facebook', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_instagram', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_linkedin', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_tripadvisor', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_foursquare', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_pinterest', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_yelp', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_youtube', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_zagat', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_zomato', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );

			// Share
			$wp_customize->add_setting( 'fy_share_heading', array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_share', array(
				'default'           => 'enabled',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );

		}

	}

	add_action( 'customize_register', 'forqy_socials_add_settings_socials_restaurant' );

}

if ( ! function_exists( 'forqy_socials_add_controls_socials_restaurant' ) ) {

	/**
	 * Add Controls
	 *
	 * @param $wp_customize
	 */
	function forqy_socials_add_controls_socials_restaurant( $wp_customize ) {

		if ( ! current_theme_supports( 'forqy-socials' ) ) {

			// Socials
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_twitter', array(
				'label'    => esc_html__( 'Twitter', 'forqy' ),
				'settings' => 'fy_twitter',
				'section'  => 'socials_restaurant',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_facebook', array(
				'label'    => esc_html__( 'Facebook', 'forqy' ),
				'settings' => 'fy_facebook',
				'section'  => 'socials_restaurant',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_instagram', array(
				'label'    => esc_html__( 'Instagram', 'forqy' ),
				'settings' => 'fy_instagram',
				'section'  => 'socials_restaurant',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_linkedin', array(
				'label'    => esc_html__( 'LinkedIn', 'forqy' ),
				'settings' => 'fy_linkedin',
				'section'  => 'socials_restaurant',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_tripadvisor', array(
				'label'    => esc_html__( 'TripAdvisor', 'forqy' ),
				'settings' => 'fy_tripadvisor',
				'section'  => 'socials_restaurant',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_foursquare', array(
				'label'    => esc_html__( 'Foursquare', 'forqy' ),
				'settings' => 'fy_foursquare',
				'section'  => 'socials_restaurant',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_pinterest', array(
				'label'    => esc_html__( 'Pinterest', 'forqy' ),
				'settings' => 'fy_pinterest',
				'section'  => 'socials_restaurant',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_yelp', array(
				'label'    => esc_html__( 'Yelp', 'forqy' ),
				'settings' => 'fy_yelp',
				'section'  => 'socials_restaurant',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_youtube', array(
				'label'    => esc_html__( 'YouTube', 'forqy' ),
				'settings' => 'fy_youtube',
				'section'  => 'socials_restaurant',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_zagat', array(
				'label'    => esc_html__( 'Zagat', 'forqy' ),
				'settings' => 'fy_zagat',
				'section'  => 'socials_restaurant',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_zomato', array(
				'label'    => esc_html__( 'Zomato', 'forqy' ),
				'settings' => 'fy_zomato',
				'section'  => 'socials_restaurant',
			) ) );

			// Share
			if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
				$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_share_heading', array(
					'label'   => esc_html_x( 'Share', 'socials', 'forqy' ),
					'type'    => 'heading',
					'section' => 'socials_restaurant',
				) ) );
			}
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_share', array(
				'label'    => esc_html_x( 'Share', 'socials', 'forqy' ),
				'settings' => 'fy_share',
				'section'  => 'socials_restaurant',
				'type'     => 'select',
				'choices'  => array(
					'enabled'  => esc_html_x( 'Enabled', 'option', 'forqy' ),
					'disabled' => esc_html_x( 'Disabled', 'option', 'forqy' ),
				),
			) ) );

		}

	}

	add_action( 'customize_register', 'forqy_socials_add_controls_socials_restaurant' );

}
