<?php

/*

Customize Socials
TODO Deprecated

*/

if ( ! function_exists( 'forqy_socials_add_section_socials_portfolio' ) ) {

	/**
	 * Add Section
	 *
	 * @param $wp_customize
	 */
	function forqy_socials_add_section_socials_portfolio( $wp_customize ) {

		$wp_customize->add_section( 'socials_portfolio', array(
			'title'       => esc_html_x( 'Socials', 'socials', 'forqy' ),
			'description' => esc_html_x( 'Fill in URLs to your social profiles.', 'socials', 'forqy' ),
			'priority'    => 141,
		) );

	}

	add_action( 'customize_register', 'forqy_socials_add_section_socials_portfolio' );

}

if ( ! function_exists( 'forqy_socials_add_settings_socials_portfolio' ) ) {

	/**
	 * Add Settings
	 *
	 * @param $wp_customize
	 */
	function forqy_socials_add_settings_socials_portfolio( $wp_customize ) {

		if ( ! current_theme_supports( 'forqy-socials' ) ) {

			$wp_customize->selective_refresh->add_partial( 'fy_twitter', array(
				'selector' => '.cs-socials'
			) );

			// Socials
			$wp_customize->add_setting( 'fy_twitter', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_facebook', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_instagram', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_pinterest', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_linkedin', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_slack', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_snapchat', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_dribbble', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_behance', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_codepen', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_unsplash', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_github', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_gitlab', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_stackoverflow', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_producthunt', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_wordpress', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_youtube', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_vimeo', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_spotify', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_soundcloud', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_itunes', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_discord', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );

			// Share
			$wp_customize->add_setting( 'fy_share_heading', array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_share', array(
				'default'           => 'enabled',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );

		}

	}

	add_action( 'customize_register', 'forqy_socials_add_settings_socials_portfolio' );

}

if ( ! function_exists( 'forqy_socials_add_controls_socials_portfolio' ) ) {

	/**
	 * Add Controls
	 *
	 * @param $wp_customize
	 */
	function forqy_socials_add_controls_socials_portfolio( $wp_customize ) {

		if ( ! current_theme_supports( 'forqy-socials' ) ) {

			// Socials
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_twitter', array(
				'label'    => esc_html__( 'Twitter', 'forqy' ),
				'settings' => 'fy_twitter',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_facebook', array(
				'label'    => esc_html__( 'Facebook', 'forqy' ),
				'settings' => 'fy_facebook',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_instagram', array(
				'label'    => esc_html__( 'Instagram', 'forqy' ),
				'settings' => 'fy_instagram',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_pinterest', array(
				'label'    => esc_html__( 'Pinterest', 'forqy' ),
				'settings' => 'fy_pinterest',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_linkedin', array(
				'label'    => esc_html__( 'LinkedIn', 'forqy' ),
				'settings' => 'fy_linkedin',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_slack', array(
				'label'    => esc_html__( 'Slack', 'forqy' ),
				'settings' => 'fy_slack',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_snapchat', array(
				'label'    => esc_html__( 'Snapchat', 'forqy' ),
				'settings' => 'fy_snapchat',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_dribbble', array(
				'label'    => esc_html__( 'Dribbble', 'forqy' ),
				'settings' => 'fy_dribbble',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_behance', array(
				'label'    => esc_html__( 'Behance', 'forqy' ),
				'settings' => 'fy_behance',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_codepen', array(
				'label'    => esc_html__( 'CodePen', 'forqy' ),
				'settings' => 'fy_codepen',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_unsplash', array(
				'label'    => esc_html__( 'Unsplash', 'forqy' ),
				'settings' => 'fy_unsplash',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_github', array(
				'label'    => esc_html__( 'GitHub', 'forqy' ),
				'settings' => 'fy_github',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_gitlab', array(
				'label'    => esc_html__( 'GitLab', 'forqy' ),
				'settings' => 'fy_gitlab',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_stackoverflow', array(
				'label'    => esc_html__( 'Stack Overflow', 'forqy' ),
				'settings' => 'fy_stackoverflow',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_producthunt', array(
				'label'    => esc_html__( 'Product Hunt', 'forqy' ),
				'settings' => 'fy_producthunt',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_wordpress', array(
				'label'    => esc_html__( 'WordPress', 'forqy' ),
				'settings' => 'fy_wordpress',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_youtube', array(
				'label'    => esc_html__( 'YouTube', 'forqy' ),
				'settings' => 'fy_youtube',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_vimeo', array(
				'label'    => esc_html__( 'Vimeo', 'forqy' ),
				'settings' => 'fy_vimeo',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_spotify', array(
				'label'    => esc_html__( 'Spotify', 'forqy' ),
				'settings' => 'fy_spotify',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_soundcloud', array(
				'label'    => esc_html__( 'SoundCloud', 'forqy' ),
				'settings' => 'fy_soundcloud',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_itunes', array(
				'label'    => esc_html__( 'iTunes', 'forqy' ),
				'settings' => 'fy_itunes',
				'section'  => 'socials_portfolio',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_discord', array(
				'label'    => esc_html__( 'Discord', 'forqy' ),
				'settings' => 'fy_discord',
				'section'  => 'socials_portfolio',
			) ) );

			// Share
			if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
				$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_share_heading', array(
					'label'   => esc_html_x( 'Share', 'socials', 'forqy' ),
					'type'    => 'heading',
					'section' => 'socials_portfolio',
				) ) );
			}
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_share', array(
				'label'    => esc_html_x( 'Share', 'socials', 'forqy' ),
				'settings' => 'fy_share',
				'section'  => 'socials_portfolio',
				'type'     => 'select',
				'choices'  => array(
					'enabled'  => esc_html_x( 'Enabled', 'option', 'forqy' ),
					'disabled' => esc_html_x( 'Disabled', 'option', 'forqy' ),
				),
			) ) );

		}

	}

	add_action( 'customize_register', 'forqy_socials_add_controls_socials_portfolio' );

}
