<?php

/*

Customize Socials
TODO Deprecated

*/

if ( ! function_exists( 'forqy_socials_add_section_socials_music' ) ) {

	/**
	 * Add Section
	 *
	 * @param $wp_customize
	 */
	function forqy_socials_add_section_socials_music( $wp_customize ) {

		$wp_customize->add_section( 'socials_music', array(
			'title'       => esc_html_x( 'Socials', 'socials', 'forqy' ),
			'description' => esc_html_x( 'Fill in URLs to your social profiles.', 'socials', 'forqy' ),
			'priority'    => 141,
		) );

	}

	add_action( 'customize_register', 'forqy_socials_add_section_socials_music' );

}

if ( ! function_exists( 'forqy_socials_add_settings_socials_music' ) ) {

	/**
	 * Add Settings
	 *
	 * @param $wp_customize
	 */
	function forqy_socials_add_settings_socials_music( $wp_customize ) {

		if ( ! current_theme_supports( 'forqy-socials' ) ) {

			$wp_customize->selective_refresh->add_partial( 'fy_twitter', array(
				'selector' => '.cs-socials'
			) );

			// Socials
			$wp_customize->add_setting( 'fy_twitter', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_facebook', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_instagram', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_youtube', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_vimeo', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_spotify', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_soundcloud', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_itunes', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_beatport', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_mixcloud', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_bandcamp', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_reverbnation', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_bandsintown', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_twitch', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_discord', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );

			// Share
			$wp_customize->add_setting( 'fy_share_heading', array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_share', array(
				'default'           => 'enabled',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );

		}

	}

	add_action( 'customize_register', 'forqy_socials_add_settings_socials_music' );

}

if ( ! function_exists( 'forqy_socials_add_controls_socials_music' ) ) {

	/**
	 * Add Controls
	 *
	 * @param $wp_customize
	 */
	function forqy_socials_add_controls_socials_music( $wp_customize ) {

		if ( ! current_theme_supports( 'forqy-socials' ) ) {

			// Socials
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_twitter', array(
				'label'    => esc_html__( 'Twitter', 'forqy' ),
				'settings' => 'fy_twitter',
				'section'  => 'socials_music',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_facebook', array(
				'label'    => esc_html__( 'Facebook', 'forqy' ),
				'settings' => 'fy_facebook',
				'section'  => 'socials_music',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_instagram', array(
				'label'    => esc_html__( 'Instagram', 'forqy' ),
				'settings' => 'fy_instagram',
				'section'  => 'socials_music',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_youtube', array(
				'label'    => esc_html__( 'YouTube', 'forqy' ),
				'settings' => 'fy_youtube',
				'section'  => 'socials_music',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_vimeo', array(
				'label'    => esc_html__( 'Vimeo', 'forqy' ),
				'settings' => 'fy_vimeo',
				'section'  => 'socials_music',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_spotify', array(
				'label'    => esc_html__( 'Spotify', 'forqy' ),
				'settings' => 'fy_spotify',
				'section'  => 'socials_music',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_soundcloud', array(
				'label'    => esc_html__( 'SoundCloud', 'forqy' ),
				'settings' => 'fy_soundcloud',
				'section'  => 'socials_music',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_itunes', array(
				'label'    => esc_html__( 'iTunes', 'forqy' ),
				'settings' => 'fy_itunes',
				'section'  => 'socials_music',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_beatport', array(
				'label'    => esc_html__( 'Beatport', 'forqy' ),
				'settings' => 'fy_beatport',
				'section'  => 'socials_music',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_mixcloud', array(
				'label'    => esc_html__( 'Mixcloud', 'forqy' ),
				'settings' => 'fy_mixcloud',
				'section'  => 'socials_music',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_bandcamp', array(
				'label'    => esc_html__( 'Bandcamp', 'forqy' ),
				'settings' => 'fy_bandcamp',
				'section'  => 'socials_music',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_reverbnation', array(
				'label'    => esc_html__( 'ReverbNation', 'forqy' ),
				'settings' => 'fy_reverbnation',
				'section'  => 'socials_music',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_bandsintown', array(
				'label'    => esc_html__( 'Bandsintown', 'forqy' ),
				'settings' => 'fy_bandsintown',
				'section'  => 'socials_music',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_twitch', array(
				'label'    => esc_html__( 'Twitch', 'forqy' ),
				'settings' => 'fy_twitch',
				'section'  => 'socials_music',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_discord', array(
				'label'    => esc_html__( 'Discord', 'forqy' ),
				'settings' => 'fy_discord',
				'section'  => 'socials_music',
			) ) );

			// Share
			if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
				$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_share_heading', array(
					'label'   => esc_html_x( 'Share', 'socials', 'forqy' ),
					'type'    => 'heading',
					'section' => 'socials_music',
				) ) );
			}
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_share', array(
				'label'    => esc_html_x( 'Share', 'socials', 'forqy' ),
				'settings' => 'fy_share',
				'section'  => 'socials_music',
				'type'     => 'select',
				'choices'  => array(
					'enabled'  => esc_html_x( 'Enabled', 'option', 'forqy' ),
					'disabled' => esc_html_x( 'Disabled', 'option', 'forqy' ),
				),
			) ) );

		}

	}

	add_action( 'customize_register', 'forqy_socials_add_controls_socials_music' );

}
