<?php

/*

Customize Socials
TODO Deprecated

*/

if ( ! function_exists( 'forqy_socials_add_section_socials_blog' ) ) {

	/**
	 * Add Section
	 *
	 * @param $wp_customize
	 */
	function forqy_socials_add_section_socials_blog( $wp_customize ) {

		$wp_customize->add_section( 'socials_blog', array(
			'title'       => esc_html_x( 'Socials', 'socials', 'forqy' ),
			'description' => esc_html_x( 'Fill in URLs to your social profiles.', 'socials', 'forqy' ),
			'priority'    => 141,
		) );

	}

	add_action( 'customize_register', 'forqy_socials_add_section_socials_blog' );

}

if ( ! function_exists( 'forqy_socials_add_settings_socials_blog' ) ) {

	/**
	 * Add Settings
	 *
	 * @param $wp_customize
	 */
	function forqy_socials_add_settings_socials_blog( $wp_customize ) {

		if ( ! current_theme_supports( 'forqy-socials' ) ) {

			$wp_customize->selective_refresh->add_partial( 'fy_twitter', array(
				'selector' => '.cs-socials'
			) );

			// Socials
			$wp_customize->add_setting( 'fy_twitter', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_facebook', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_instagram', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_amazon', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_reddit', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_pinterest', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_linkedin', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_youtube', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_vimeo', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_foursquare', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_spotify', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_soundcloud', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_itunes', array(
				'default'           => '',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );

			// Share
			$wp_customize->add_setting( 'fy_share_heading', array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
			) );
			$wp_customize->add_setting( 'fy_share', array(
				'default'           => 'enabled',
				'transport'         => 'refresh',
				'sanitize_callback' => 'sanitize_text_field',
			) );

		}

	}

	add_action( 'customize_register', 'forqy_socials_add_settings_socials_blog' );

}

if ( ! function_exists( 'forqy_socials_add_controls_socials_blog' ) ) {

	/**
	 * Add Controls
	 *
	 * @param $wp_customize
	 */
	function forqy_socials_add_controls_socials_blog( $wp_customize ) {

		if ( ! current_theme_supports( 'forqy-socials' ) ) {

			// Socials
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_twitter', array(
				'label'    => esc_html__( 'Twitter', 'forqy' ),
				'settings' => 'fy_twitter',
				'section'  => 'socials_blog',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_facebook', array(
				'label'    => esc_html__( 'Facebook', 'forqy' ),
				'settings' => 'fy_facebook',
				'section'  => 'socials_blog',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_instagram', array(
				'label'    => esc_html__( 'Instagram', 'forqy' ),
				'settings' => 'fy_instagram',
				'section'  => 'socials_blog',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_amazon', array(
				'label'    => esc_html__( 'Amazon', 'forqy' ),
				'settings' => 'fy_amazon',
				'section'  => 'socials_blog',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_reddit', array(
				'label'    => esc_html__( 'Reddit', 'forqy' ),
				'settings' => 'fy_reddit',
				'section'  => 'socials_blog',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_pinterest', array(
				'label'    => esc_html__( 'Pinterest', 'forqy' ),
				'settings' => 'fy_pinterest',
				'section'  => 'socials_blog',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_linkedin', array(
				'label'    => esc_html__( 'LinkedIn', 'forqy' ),
				'settings' => 'fy_linkedin',
				'section'  => 'socials_blog',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_youtube', array(
				'label'    => esc_html__( 'YouTube', 'forqy' ),
				'settings' => 'fy_youtube',
				'section'  => 'socials_blog',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_vimeo', array(
				'label'    => esc_html__( 'Vimeo', 'forqy' ),
				'settings' => 'fy_vimeo',
				'section'  => 'socials_blog',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_foursquare', array(
				'label'    => esc_html__( 'Foursquare', 'forqy' ),
				'settings' => 'fy_foursquare',
				'section'  => 'socials_blog',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_spotify', array(
				'label'    => esc_html__( 'Spotify', 'forqy' ),
				'settings' => 'fy_spotify',
				'section'  => 'socials_blog',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_soundcloud', array(
				'label'    => esc_html__( 'SoundCloud', 'forqy' ),
				'settings' => 'fy_soundcloud',
				'section'  => 'socials_blog',
			) ) );

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_itunes', array(
				'label'    => esc_html__( 'iTunes', 'forqy' ),
				'settings' => 'fy_itunes',
				'section'  => 'socials_blog',
			) ) );

			// Share
			if ( class_exists( 'forqy_Customize_Heading_Control' ) ) {
				$wp_customize->add_control( new forqy_Customize_Heading_Control( $wp_customize, 'fy_share_heading', array(
					'label'   => esc_html_x( 'Share', 'socials', 'forqy' ),
					'type'    => 'heading',
					'section' => 'socials_blog',
				) ) );
			}
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'fy_share', array(
				'label'    => esc_html_x( 'Share', 'socials', 'forqy' ),
				'settings' => 'fy_share',
				'section'  => 'socials_blog',
				'type'     => 'select',
				'choices'  => array(
					'enabled'  => esc_html_x( 'Enabled', 'option', 'forqy' ),
					'disabled' => esc_html_x( 'Disabled', 'option', 'forqy' ),
				),
			) ) );

		}

	}

	add_action( 'customize_register', 'forqy_socials_add_controls_socials_blog' );

}
