<?php

/**
 * FORQY Shortcodes
 *
 * @version 1.0.3
 * @author  FORQY
 * @url     https://forqy.website/
 * @license GPL-3.0-or-later
 */

if ( ! function_exists( 'forqy_shortcodes_styles' ) ) {

	/**
	 * Styles
	 */
	function forqy_shortcodes_styles() {

		wp_register_style( 'forqy-shortcodes', plugins_url( 'assets/css/shortcodes.css', __FILE__ ), array() );
		wp_enqueue_style( 'forqy-shortcodes' );

	}

	add_action( 'admin_enqueue_scripts', 'forqy_shortcodes_styles', 200 );

}

if ( ! function_exists( 'forqy_shortcodes_remove_auto_p' ) ) {

	/**
	 * Remove Auto Paragraphs in Shortcodes
	 * @url https://gist.github.com/ozamancse/de16034f7a72f5e78f394c9e90091157
	 *
	 * @param $content
	 *
	 * @return string
	 */
	function forqy_shortcodes_remove_auto_p( $content ) {

		$array = array(
			'<p>['    => '[',
			']</p>'   => ']',
			']<br />' => ']',
			']<br>'   => ']'
		);

		return strtr( $content, $array );
	}

	add_filter( 'the_content', 'forqy_shortcodes_remove_auto_p' );

}

if ( ! function_exists( 'forqy_shortcodes_tinymce_buttons' ) ) {

	/**
	 * Register TinyMCE Plugin
	 */
	function forqy_shortcodes_tinymce_buttons() {

		// Check user permissions
		if ( ! current_user_can( 'edit_posts' ) && ! current_user_can( 'edit_pages' ) ) {
			return;
		}

		// Check the editor
		if ( get_user_option( 'rich_editing' ) == 'true' ) {
			// Register TinyMCE Plugin
			add_filter( 'mce_external_plugins', 'forqy_shortcodes_tinymce_register_plugin' );
			// Register TinyMCE Buttons
			add_filter( 'mce_buttons', 'forqy_shortcodes_tinymce_register_buttons' );
		}
	}

	add_action( 'admin_head', 'forqy_shortcodes_tinymce_buttons', 15 );

}

if ( ! function_exists( 'forqy_shortcodes_tinymce_register_plugin' ) ) {

	/**
	 * Register TinyMCE Plugin
	 *
	 * @param $plugin_array
	 *
	 * @return mixed
	 */
	function forqy_shortcodes_tinymce_register_plugin( $plugin_array ) {
		$plugin_array['fy_shortcodes'] = plugins_url( 'assets/js/editor.js', __FILE__ );

		return $plugin_array;
	}

}

if ( ! function_exists( 'forqy_shortcodes_tinymce_register_buttons' ) ) {

	/**
	 * Define Shortcodes
	 *
	 * @param $buttons
	 *
	 * @return mixed
	 */
	function forqy_shortcodes_tinymce_register_buttons( $buttons ) {
		array_push( $buttons, 'fy_shortcodes' );

		return $buttons;
	}

}
