<?php

/*

Typography Shortcodes

*/

/*
----------------------------------------------------------------------------------------------------
[fy-dropcap type="default" color="default"][/fy-dropcap]
[forqy-dropcap type="default" color="default"][/forqy-dropcap]
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_shortcode_dropcap' ) ) {

	function forqy_shortcode_dropcap( $attrs, $content = null ) {

		$attrs = shortcode_atts( array(
			'type'  => 'default', // default, square, rounded
			'color' => 'default', // default, accent
		), $attrs );

		$dropcap_class = 'fy-dropcap';
		$dropcap_class .= $attrs['type'] ? ' fy-dropcap-' . $attrs['type'] : '';
		$dropcap_class .= $attrs['color'] ? ' fy-dropcap-color-' . $attrs['color'] : '';

		$dropcap = '<span class="fy-shortcode-dropcap ' . $dropcap_class . '">';
		$dropcap .= wp_kses_post( $content );
		$dropcap .= '</span>';

		return $dropcap;

	}

	add_shortcode( 'fy-dropcap', 'forqy_shortcode_dropcap' );
	add_shortcode( 'forqy-dropcap', 'forqy_shortcode_dropcap' );

}

/*
----------------------------------------------------------------------------------------------------
[fy-leadin position="left" color="default"][/fy-leadin]
[forqy-leadin position="left" color="default"][/forqy-leadin]
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_shortcode_leadin' ) ) {

	function forqy_shortcode_leadin( $attrs, $content = null ) {

		$attrs = shortcode_atts( array(
			'position' => 'left', // left, right, full
			'color'    => 'default', // default, accent
		), $attrs );

		$leadin_class = 'fy-leadin';
		$leadin_class .= $attrs['position'] ? ' fy-leadin-' . $attrs['position'] : '';
		$leadin_class .= $attrs['color'] ? ' fy-leadin-color-' . $attrs['color'] : '';

		$leadin = '<div class="fy-shortcode-leadin ' . $leadin_class . '">';
		$leadin .= wp_kses_post( $content );
		$leadin .= '</div>';

		return $leadin;

	}

	add_shortcode( 'fy-leadin', 'forqy_shortcode_leadin' );
	add_shortcode( 'forqy-leadin', 'forqy_shortcode_leadin' );

}

/*
----------------------------------------------------------------------------------------------------
[fy-highlight color="default"][/fy-highlight]
[forqy-highlight color="default"][/forqy-highlight]
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_shortcode_highlight' ) ) {

	function forqy_shortcode_highlight( $attrs, $content = null ) {

		$attrs = shortcode_atts( array(
			'color' => 'default', // default, accent
		), $attrs );

		$highlight_class = 'fy-highlight';
		$highlight_class .= $attrs['color'] ? ' fy-highlight-color-' . $attrs['color'] : '';

		$highlight = '<mark class="fy-shortcode-highlight ' . $highlight_class . '">';
		$highlight .= wp_kses_post( $content );
		$highlight .= '</mark>';

		return $highlight;

	}

	add_shortcode( 'fy-highlight', 'forqy_shortcode_highlight' );
	add_shortcode( 'forqy-highlight', 'forqy_shortcode_highlight' );

}

/*
----------------------------------------------------------------------------------------------------
[fy-emphasize color="default"][/fy-emphasize]
[forqy-emphasize color="default"][/fy-emphasize]
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_shortcode_emphasize' ) ) {

	function forqy_shortcode_emphasize( $attrs, $content = null ) {

		$attrs = shortcode_atts( array(
			'color' => 'default', // default, accent
		), $attrs );

		$emphasize_class = 'fy-emphasize';
		$emphasize_class .= $attrs['color'] ? ' fy-emphasize-color-' . $attrs['color'] : '';

		$emphasize = '<span class="fy-shortcode-emphasize ' . $emphasize_class . '">';
		$emphasize .= wp_kses_post( shortcode_unautop( $content ) );
		$emphasize .= '</span>';

		return $emphasize;

	}

	add_shortcode( 'fy-emphasize', 'forqy_shortcode_emphasize' );
	add_shortcode( 'forqy-emphasize', 'forqy_shortcode_emphasize' );

}
