<?php

/*

Progress Shortcodes

*/

/*
----------------------------------------------------------------------------------------------------
[fy-progress type="default" value="60%"][/fy-progress]
[forqy-progress type="default" value="60%"][/forqy-progress]
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_shortcode_progress' ) ) {

	function forqy_shortcode_progress( $attrs, $content = null ) {

		$attrs = shortcode_atts( array(
			'type'  => 'default', // default, primary, secondary, accent, success, error
			'value' => '50%' // 0% - 100%
		), $attrs );

		$progress_bar_class = $attrs['type'] ? 'fy-progress-bar-' . $attrs['type'] : null;

		$progress = '<div class="fy-progress">';
		$progress .= '<div class="fy-progress-bar ' . $progress_bar_class . '" style="width: ' . $attrs['value'] . ';" aria-valuenow="' . str_replace( '%', '', $attrs['value'] ) . '" aria-valuemin="0" aria-valuemax="100" role="progressbar">';
		$progress .= wp_kses_post( $content );
		$progress .= '</div>';
		$progress .= '</div>';

		return $progress;

	}

	add_shortcode( 'fy-progress', 'forqy_shortcode_progress' );
	add_shortcode( 'forqy-progress', 'forqy_shortcode_progress' );

}
