<?php

/*

Image Shortcodes

*/

/*
----------------------------------------------------------------------------------------------------
[fy-image src="#" size="medium" align="none" lightbox=""]Image Caption[/fy-image]
[forqy-image src="#" size="medium" align="none" lightbox=""]Image Caption[/forqy-image]
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_shortcode_image' ) ) {

	function forqy_shortcode_image( $attrs, $content = null ) {
		global $index;

		ob_start();

		$attrs = shortcode_atts( array(
			'src'      => '',
			'size'     => 'medium', // thumbnail, medium, large, full
			'align'    => 'none', // none, left, right, center
			'lightbox' => '', // none
		), $attrs );

		$image_id   = attachment_url_to_postid( $attrs['src'] );
		$image_meta = wp_get_attachment_metadata( $image_id );
		$image_big  = wp_get_attachment_image_src( $image_id, 'full' );

		// Construct Image
		$image = '<figure class="fy-page-image fy-page-image-' . esc_attr( $image_id ) . ' fy-align-' . esc_attr( $attrs['align'] ) . '">';

		if ( ! empty ( $image_big ) && $attrs['lightbox'] != 'none' ) {
			$image .= '<a href="' . esc_url( $image_big[0] ) . '" class="js-image" data-index="' . esc_attr( $index ++ ) . '" data-size="' . esc_attr( $image_meta['width'] ) . 'x' . esc_attr( $image_meta['height'] ) . '">';
		}

		$image .= '<img class="fy-image fy-image-responsive" src="' . esc_url( $attrs['src'] ) . '" alt="' . esc_attr( $content ) . '">';

		if ( ! empty ( $image_big ) && $attrs['lightbox'] != 'none' ) {
			$image .= '</a>';
		}

		$image .= '<figcaption class="fy-page-image-caption screen-reader-text">';
		$image .= wp_kses_post( $content );
		$image .= '</figcaption>';

		$image .= '</figure>';

		return $image;

	}

	add_shortcode( 'fy-image', 'forqy_shortcode_image' );
	add_shortcode( 'forqy-image', 'forqy_shortcode_image' );

}
