<?php

/*

Form Shortcodes

*/

/*
----------------------------------------------------------------------------------------------------
[fy-form-contact width="auto"]
[forqy-form-contact width="auto"]
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_contact_form_shortcode' ) ) {

	function forqy_contact_form_shortcode( $attrs ) {
		ob_start();

		$attrs = shortcode_atts( array(
			'width' => 'auto', // auto, 50, 75, 100
		), $attrs );

		if ( function_exists( 'forqy_form_contact' ) ) { ?>

            <div class="fy-shortcode-form">
				<?php if ( ! empty ( $attrs['width'] ) && $attrs['width'] != 'auto' ) { ?>
                    <div class="fy-centerer fy-centerer-<?php echo esc_attr( $attrs['width'] ); ?>">
						<?php forqy_form_contact(); ?>
                    </div>
				<?php } else {
					forqy_form_contact();
				} ?>
            </div>

			<?php
		}

		$out = ob_get_clean();

		return shortcode_unautop( $out );
	}

	add_shortcode( 'fy-form-contact', 'forqy_contact_form_shortcode' );
	add_shortcode( 'forqy-form-contact', 'forqy_contact_form_shortcode' );

}

/*
----------------------------------------------------------------------------------------------------
[fy-form-reservation width="auto"]
[forqy-form-reservation width="auto"]
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_reservation_form_shortcode' ) ) {

	function forqy_reservation_form_shortcode( $attrs ) {
		ob_start();

		$attrs = shortcode_atts( array(
			'width' => 'auto', // auto, 50, 75, 100
		), $attrs );

		if ( function_exists( 'forqy_form_reservation' ) ) { ?>

            <div class="fy-shortcode-form">
				<?php if ( ! empty ( $attrs['width'] ) && $attrs['width'] != 'auto' ) { ?>
                    <div class="fy-centerer fy-centerer-<?php echo esc_attr( $attrs['width'] ); ?>">
						<?php forqy_form_reservation(); ?>
                    </div>
				<?php } else {
					forqy_form_reservation();
				} ?>
            </div>

			<?php
		}

		$out = ob_get_clean();

		return shortcode_unautop( $out );

	}

	add_shortcode( 'fy-form-reservation', 'forqy_reservation_form_shortcode' );
	add_shortcode( 'forqy-form-reservation', 'forqy_reservation_form_shortcode' );

}
