<?php

/*

Flex Shortcodes

*/

/*
----------------------------------------------------------------------------------------------------
[fy-container align="top" gutter="medium"][/fy-container]
[forqy-container align="top" gutter="medium"][/forqy-container]
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_shortcode_container' ) ) {

	function forqy_shortcode_container( $attrs, $content = null ) {

		$attrs = shortcode_atts( array(
			'align'  => 'top', // top, center, bottom, stretch, baseline, initial
			'gutter' => 'medium', // 0, 1, xsmall, small, medium, large, xlarge
		), $attrs );

		$container_class = 'fy-flex-container';
		$container_class .= ' fy-flex-container-' . $attrs['align'];
		$container_class .= ' fy-flex-gutter-' . $attrs['gutter'];

		$container = '<div class="fy-shortcode-container ' . $container_class . '">';
		$container .= do_shortcode( shortcode_unautop( $content ) );
		$container .= '</div>';

		return $container;

	}

	add_shortcode( 'fy-container', 'forqy_shortcode_container' );
	add_shortcode( 'forqy-container', 'forqy_shortcode_container' );

}

/*
----------------------------------------------------------------------------------------------------
[fy-column width="auto" width-tablet="" width-phone=""][/fy-column]
[forqy-column width="auto" width-tablet="" width-phone=""][/forqy-column]
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_shortcode_column' ) ) {

	function forqy_shortcode_column( $attrs, $content = null ) {

		$attrs = shortcode_atts( array(
			'width'        => 'auto',
			// auto, 100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 5
			'width-tablet' => '',
			// auto, 100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 5
			'width-phone'  => '',
			// auto, 100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 5
		), $attrs );

		$column_class = 'fy-flex-column-' . $attrs['width'];
		$column_class .= $attrs['width-tablet'] ? ' fy-flex-column-tablet-' . $attrs['width-tablet'] : '';
		$column_class .= $attrs['width-phone'] ? ' fy-flex-column-phone-' . $attrs['width-phone'] : '';

		$column = '<div class="fy-shortcode-column ' . $column_class . '">';
		$column .= do_shortcode( shortcode_unautop( $content ) );
		$column .= '</div>';

		return $column;

	}

	add_shortcode( 'fy-column', 'forqy_shortcode_column' );
	add_shortcode( 'forqy-column', 'forqy_shortcode_column' );

}
