<?php

/*

Divider Shortcodes

*/

/*
----------------------------------------------------------------------------------------------------
[fy-divider type="solid" color="default"]
[forqy-divider type="solid" color="default"]
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_shortcode_divider' ) ) {

	function forqy_shortcode_divider( $attrs ) {

		$attrs = shortcode_atts( array(
			'type'  => 'solid', // solid, dotted, dashed, double
			'color' => 'default', // default, accent
		), $attrs );

		$divider_class = 'fy-divider';
		$divider_class .= $attrs['type'] ? ' fy-divider-' . $attrs['type'] : '';
		$divider_class .= $attrs['color'] ? ' fy-divider-color-' . $attrs['color'] : '';

		return '<div class="fy-shortcode-divider ' . $divider_class . '"></div>';

	}

	add_shortcode( 'fy-divider', 'forqy_shortcode_divider' );
	add_shortcode( 'forqy-divider', 'forqy_shortcode_divider' );

}
