<?php

/*

Centerer Shortcodes

*/

/*
----------------------------------------------------------------------------------------------------
[fy-centerer size="100"][/fy-centerer]
[forqy-centerer size="100"][/forqy-centerer]
----------------------------------------------------------------------------------------------------
*/

if ( ! function_exists( 'forqy_shortcode_centerer' ) ) {

	function forqy_shortcode_centerer( $attrs, $content = null ) {

		$attrs = shortcode_atts( array(
			'size' => '100', // 100, 75, 50
		), $attrs );

		$centerer_class = 'fy-centerer';
		$centerer_class .= ' fy-centerer-' . $attrs['size'];

		$centerer = '<div class="fy-shortcode-centerer ' . $centerer_class . '">';
		$centerer .= do_shortcode( shortcode_unautop( $content ) );
		$centerer .= '</div>';

		return $centerer;

	}

	add_shortcode( 'fy-centerer', 'forqy_shortcode_centerer' );
	add_shortcode( 'forqy-centerer', 'forqy_shortcode_centerer' );

}
